<?php
include("connect.php");

/* Pagination */
$limit = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = ($page < 1) ? 1 : $page;
$offset = ($page - 1) * $limit;

/* Search */
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$where = "";

if ($search != '') {
    $search_safe = mysqli_real_escape_string($conn, $search);
    $where = " WHERE instrument_no LIKE '%$search_safe%' 
               OR narration LIKE '%$search_safe%'";
}

/* Total rows */
$count_sql = "SELECT COUNT(*) AS total FROM fdr_statement $where";
$count_res = mysqli_query($conn, $count_sql);
$total_rows = mysqli_fetch_assoc($count_res)['total'];
$total_pages = ceil($total_rows / $limit);

/* Data */
$sql = "SELECT * FROM fdr_statement 
        $where 
        ORDER BY transaction_date DESC, id DESC
        LIMIT $limit OFFSET $offset";
$result = mysqli_query($conn, $sql);
$sn = $offset + 1;
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>FDR Statement List</title>

    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: #f4f6f9;
        }

        .content {
            margin-left: 250px;
            padding: 30px;
            padding-top: 90px;
        }

        .card {
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, .1);
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        table th,
        table td {
            border: 1px solid #ddd;
            padding: 8px;
            font-size: 14px;
            text-align: center;
        }

        table th {
            background: #007bff;
            color: #fff;
        }

        .search-box {
            margin-bottom: 10px;
        }

        .search-box input {
            padding: 8px;
            width: 250px;
        }

        .search-box button {
            padding: 8px 12px;
        }

        .credit {
            color: green;
            font-weight: bold;
        }

        .debit {
            color: red;
            font-weight: bold;
        }

        /* Pagination */
        .pagination {
            margin-top: 20px;
            text-align: center;
        }

        .pagination a {
            display: inline-block;
            padding: 6px 12px;
            margin: 2px;
            border: 1px solid #007bff;
            color: #007bff;
            text-decoration: none;
            border-radius: 4px;
        }

        .pagination a.active {
            background: #007bff;
            color: #fff;
            font-weight: bold;
        }

        .pagination .dots {
            padding: 6px 8px;
            color: #555;
        }
        .header {
            height: 60px;
            background: #ffffff;
            border-bottom: 1px solid #ddd;
            position: fixed;
            top: 0;
            left: 250px;
            /* sidebar width */
            right: 0;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            z-index: 1000;
        }

        .header-left {
            font-size: 16px;
            font-weight: bold;
        }

        .logout-btn {
            background: #dc3545;
            color: #fff;
            padding: 8px 14px;
            text-decoration: none;
            border-radius: 5px;
            font-size: 14px;
        }

        .logout-btn:hover {
            background: #b52a37;
        }
    </style>
</head>

<body>

    <?php include("sidebar.php"); ?>
    <?php include("header.php"); ?>

    <div class="content">
        <div class="card">

            <h2>FDR Statement List</h2>

            <!-- Search -->
            <form method="get" class="search-box">
                <input type="text" name="search"
                    placeholder="Search Instrument / Narration"
                    value="<?php echo htmlspecialchars($search); ?>">
                <button type="submit">Search</button>
            </form>

            <!-- Table -->
            <table>
                <tr>
                    <th>S.No</th>
                    <th>Transaction Date</th>
                    <th>Value Date</th>
                    <th>Instrument No</th>
                    <th>Narration</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    <th>Balance</th>
                </tr>

                <?php
                if (mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {


                ?>
                        <tr>
                            <td><?php echo $sn++; ?></td>
                            <td><?php echo $row['transaction_date']; ?></td>
                            <td><?php echo $row['value_date']; ?></td>
                            <td><?php echo $row['instrument_no']; ?></td>
                            <td style="text-align:left"><?php echo $row['narration']; ?></td>
                            <td><?php echo number_format($row['debit_amount'], 2); ?></td>
                            <td><?php echo number_format($row['credit_amount'], 2); ?></td>
                            <td><?php echo $row['balance']; ?></td>
                        </tr>
                    <?php }
                } else { ?>
                    <tr>
                        <td colspan="8">No records found</td>
                    </tr>
                <?php } ?>
            </table>

            <!-- Pagination -->
            <div class="pagination">
                <?php
                $range = 2;

                // Prev
                if ($page > 1) {
                    echo '<a href="?page=' . ($page - 1) . '&search=' . urlencode($search) . '">« Prev</a>';
                }

                // First
                if ($page > ($range + 1)) {
                    echo '<a href="?page=1&search=' . urlencode($search) . '">1</a>';
                    echo '<span class="dots">...</span>';
                }

                // Pages
                for ($i = max(1, $page - $range); $i <= min($total_pages, $page + $range); $i++) {
                    if ($i == $page) {
                        echo '<a class="active">' . $i . '</a>';
                    } else {
                        echo '<a href="?page=' . $i . '&search=' . urlencode($search) . '">' . $i . '</a>';
                    }
                }

                // Last
                if ($page < ($total_pages - $range)) {
                    echo '<span class="dots">...</span>';
                    echo '<a href="?page=' . $total_pages . '&search=' . urlencode($search) . '">' . $total_pages . '</a>';
                }

                // Next
                if ($page < $total_pages) {
                    echo '<a href="?page=' . ($page + 1) . '&search=' . urlencode($search) . '">Next »</a>';
                }
                ?>
            </div>

        </div>
    </div>

</body>

</html>