<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Bank Statement Upload</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f6f9;
        }

        .container {
            width: 450px;
            margin: 100px auto;
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        input[type="file"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
        }

        button {
            width: 100%;
            padding: 12px;
            background: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
        }

        button:hover {
            background: #0056b3;
        }

        .note {
            font-size: 12px;
            color: #666;
            margin-top: 10px;
            text-align: center;
        }

        .header {
            height: 60px;
            background: #ffffff;
            border-bottom: 1px solid #ddd;
            position: fixed;
            top: 0;
            left: 250px;
            /* sidebar width */
            right: 0;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            z-index: 1000;
        }

        .header-left {
            font-size: 16px;
            font-weight: bold;
        }

        .logout-btn {
            background: #dc3545;
            color: #fff;
            padding: 8px 14px;
            text-decoration: none;
            border-radius: 5px;
            font-size: 14px;
        }

        .logout-btn:hover {
            background: #b52a37;
        }
    </style>
</head>

<body>

    <?php include("sidebar.php"); ?>
    <?php include("header.php"); ?>

    <div class="content">
        <div class="container">
            <h2>Upload Bank Statement</h2>

            <form action="upload.php" method="post" enctype="multipart/form-data">
                <input type="file" name="excel_file" required>
                <button type="submit">Upload & Import</button>
            </form>

            <div class="note">
                Allowed formats: .xlsx, .xls
            </div>
        </div>
    </div>

    <script>
        function toggleMenu(id) {
            var menu = document.getElementById(id);
            menu.style.display = (menu.style.display === "block") ? "none" : "block";
        }
    </script>

</body>

</html>