<?php
session_start();
include('include/config.php');
error_reporting(0);

if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Invalid request.");
}

$pid = intval($_GET['id']);

// Fetch main prescription
$prescription = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM prescriptions WHERE pid = $pid"));

// Fetch associated prescription items
$items = mysqli_query($con, "SELECT * FROM prescription_items WHERE pid = $pid");

// Update logic
if (isset($_POST['update'])) {
    $pname = $_POST['pname'];
    $diagnosis = $_POST['diagnosis'];
    $prescription_text = $_POST['prescription'];
    $notes = $_POST['notes'];

    mysqli_query($con, "UPDATE prescriptions SET pname='$pname', diagnosis='$diagnosis', prescription='$prescription_text', notes='$notes' WHERE pid=$pid");

    foreach ($_POST['item_id'] as $index => $item_id) {
        $med_name = $_POST['medicine_name'][$index];
        $dosage = $_POST['dosage'][$index];
        $duration = $_POST['duration'][$index];

        mysqli_query($con, "UPDATE prescription_items 
            SET medicine_name='$med_name', dosage='$dosage', duration='$duration' 
            WHERE id=$item_id");
    }

    $success = "Prescription updated successfully!";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | Edit Patient Prescription</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
    <link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Edit Patient Prescription</h1>
                        </div>
                        <!-- <ol class="breadcrumb">
                            <li><span>Patient</span></li>
                            <li class="active"><span>Edit Prescription</span></li>
                        </ol> -->
                    </div>
                </section>
                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if (isset($success)) { ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <?= $success ?>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            <?php } ?>

                            <a href="view-prescription.php" class="btn btn-secondary mb-3">← Back to Prescription List</a>

                            <form method="post">
                                <div class="form-group">
                                    <label>Patient Name</label>
                                    <input type="text" name="pname" class="form-control" value="<?= htmlspecialchars($prescription['pname']) ?>" required>
                                </div>

                                <div class="form-group">
                                    <label>Diagnosis</label>
                                    <input type="text" name="diagnosis" class="form-control" value="<?= htmlspecialchars($prescription['diagnosis']) ?>" required>
                                </div>

                                <div class="form-group">
                                    <label>Prescription</label>
                                    <textarea name="prescription" class="form-control"><?= htmlspecialchars($prescription['prescription']) ?></textarea>
                                </div>

                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea name="notes" class="form-control"><?= htmlspecialchars($prescription['notes']) ?></textarea>
                                </div>

                                
                                <!-- <h4>Prescription Items</h4> -->
                                <?php while ($item = mysqli_fetch_assoc($items)) { ?>
                                    <div class="border p-3 mb-3 rounded">
                                        <input type="hidden" name="item_id[]" value="<?= $item['id'] ?>">

                                        <!-- <div class="form-group">
                                            <label>Medicine Name</label>
                                            <input type="text" name="medicine_name[]" class="form-control" value="<?= htmlspecialchars($item['medicine_name']) ?>" required>
                                        </div> -->

                                        <div class="form-group">
                                            <label>Dosage</label>
                                            <input type="text" name="dosage[]" class="form-control" value="<?= htmlspecialchars($item['dosage']) ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Duration</label>
                                            <input type="text" name="duration[]" class="form-control" value="<?= htmlspecialchars($item['duration']) ?>" required>
                                        </div>
                                    </div>
                                <?php } ?>

                                <button type="submit" name="update" class="btn btn-primary">Update Prescription</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php include('include/footer.php'); ?>
        <?php include('include/setting.php'); ?>
    </div>
</div>

<!-- JS Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="vendor/autosize/autosize.min.js"></script>
<script src="vendor/selectFx/classie.js"></script>
<script src="vendor/selectFx/selectFx.js"></script>
<script src="vendor/select2/select2.min.js"></script>
<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="assets/js/form-elements.js"></script>
<script>
    jQuery(document).ready(function() {
        Main.init();
        FormElements.init();
    });
</script>
</body>
</html>
