<?php
include('include/config.php');

$patientId     = intval($_GET['patient_id']);

$q = "
SELECT p.id AS pid, p.notes, p.scan, p.lab, p.revisit_date, p.created_at,
       pi.drug_name, pi.dose, pi.duration, pi.duration_unit,
       pi.strength, pi.strength_unit, pi.food_instruction,
       pi.morning, pi.afternoon, pi.evening, pi.night
FROM prescriptions p
LEFT JOIN prescription_items pi ON p.id = pi.prescription_id
WHERE p.patient_id = '$patientId'
ORDER BY p.id DESC
";
$res = mysqli_query($con, $q);


if (mysqli_num_rows($res) > 0) {
    echo "<table class='table table-bordered'>";
    echo "<thead><tr>
        <th>Created Date</th>
        <th>Medicine</th><th>Strength</th><th>Dose</th>
        <th>Duration</th><th>Food Advice</th>
        <th>Morning</th><th>Afternoon</th><th>Evening</th><th>Night</th>
    </tr></thead><tbody>";

    while ($row = mysqli_fetch_assoc($res)) {
        echo "<tr>
            <td>".date('d/m/Y H:i:A', strtotime($row['created_at']))."</td>
            <td>{$row['drug_name']}</td>
            <td>{$row['strength']} {$row['strength_unit']}</td>
            <td>{$row['dose']}</td>
            <td>{$row['duration']} {$row['duration_unit']}</td>
            <td>{$row['food_instruction']}</td>
            <td>".($row['morning'] ? '✅' : '❌')."</td>
            <td>".($row['afternoon'] ? '✅' : '❌')."</td>
            <td>".($row['evening'] ? '✅' : '❌')."</td>
            <td>".($row['night'] ? '✅' : '❌')."</td>
        </tr>";
    }
    echo "</tbody></table>";

    // Show Notes, Lab, Scan, Revisit once
    mysqli_data_seek($res, 0); // rewind
    $extra = mysqli_fetch_assoc($res);
    echo "<h6 class='mt-3'>Other Info</h6>
          <p><b>Notes:</b> {$extra['notes']}</p>
          <p><b>Scan:</b> {$extra['scan']}</p>
                    <p><b>Lab:</b> {$extra['lab']}</p>

          <p><b>Revisit Date:</b> ".date('d/m/Y', strtotime($extra['revisit_date']))."</p>";
} else {
    echo "No prescriptions found.";
}
?>
