<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$msg = "";

// ============================
// Auto-generate Invoice No
// ============================
$result = mysqli_query($con, "SELECT invoice_no FROM medicine_stock ORDER BY id DESC LIMIT 1");
if ($row = mysqli_fetch_assoc($result)) {
    $lastNo = intval(substr($row['invoice_no'], 3));
    $nextNo = $lastNo + 1;
} else {
    $nextNo = 1;
}
$invoice_no = 'INV' . str_pad($nextNo, 5, '0', STR_PAD_LEFT);

// ============================
// Handle form submission
// ============================
if (isset($_POST['submit'])) {

    $vendor_name   = mysqli_real_escape_string($con, $_POST['vendor_name']);
    $inward_date   = $_POST['inward_date'];
    
    $purchase_rate = floatval($_POST['purchase_rate']);
    $selling_price = floatval($_POST['selling_price']);
    $gst_amount    = floatval($_POST['gst_amount']);
    $total_amount  = floatval($_POST['total_amount'] ?? 0); // fallback 0

    $medicine_codes = $_POST['medicine_code'] ?? [];
    $medicine_names = $_POST['medicine_name'] ?? [];
    $strengths      = $_POST['strength'] ?? [];
    $units          = $_POST['unit_type'] ?? [];
    $batches        = $_POST['batch_number'] ?? [];
    $quantities     = $_POST['quantity'] ?? [];

    $success = 0;
    $error = 0;

    foreach ($medicine_codes as $i => $code) {
        if (empty($code)) continue; // skip empty rows

        $name  = mysqli_real_escape_string($con, $medicine_names[$i]);
        $str   = mysqli_real_escape_string($con, $strengths[$i]);
        $unit  = mysqli_real_escape_string($con, $units[$i]);
        $batch = mysqli_real_escape_string($con, $batches[$i]);
        $qty   = intval($quantities[$i]);

        $stmt = $con->prepare("INSERT INTO medicine_stock 
            (invoice_no, inward_date, vendor_name, medicine_code, medicine_name, strength, unit_type, batch_number, quantity, purchase_rate, selling_price, gst_amount, total_amount)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        
        if (!$stmt) {
            die("Prepare failed: " . $con->error);
        }

        $stmt->bind_param(
    "ssssssssidddd",
    $invoice_no, $inward_date, $vendor_name, $code, $name, $str, $unit, $batch, $qty, $purchase_rate, $selling_price, $gst_amount, $total_amount
);


        if ($stmt->execute()) {
            $success++;
        } else {
            $error++;
        }
        $stmt->close();
    }

    if ($success > 0) {
        $msg = "Medicine stock added successfully! Invoice No: $invoice_no";
        $lastNo = intval(substr($invoice_no, 3)) + 1;
        $invoice_no = 'INV' . str_pad($lastNo, 5, '0', STR_PAD_LEFT);
    } else {
        $msg = "Error adding stock. Please check all fields.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Pharmacy | Add Medicine Stock</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
    body { background: #f8f9fa; }
    .card { box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    .scroll-container { max-height: 400px; overflow-y:auto; border:1px solid #dee2e6; padding:10px; background:#fff; }
</style>
</head>
<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>
        <div class="main-panel">
            <div class="content-wrapper">

                <div class="container bg-white p-4 rounded shadow-sm">
                    <?php if($msg) echo '<div class="alert alert-info">'.$msg.'</div>'; ?>
                    <form method="POST">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label>Invoice No</label>
                                <input type="text" class="form-control" name="invoice_no" value="<?= $invoice_no ?>" readonly>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>Inward Date</label>
                                <input type="date" class="form-control" name="inward_date" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>Vendor Name</label>
                                <select name="vendor_name" class="form-control" required>
                                    <option value="">-- Select Vendor --</option>
                                    <?php
                                    $vendor_result = mysqli_query($con, "SELECT DISTINCT vendor_name FROM vendor_masters WHERE vendor_name != '' ORDER BY vendor_name ASC");
                                    while ($row = mysqli_fetch_assoc($vendor_result)) {
                                        echo '<option value="' . htmlspecialchars($row['vendor_name']) . '">' . htmlspecialchars($row['vendor_name']) . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>

                        </div>

                        <div class="scroll-container mt-3">
                            <h5>Medicine Items</h5>
                            <table class="table table-bordered" id="medicineTable">
                                <thead>
                                    <tr>
                                        <th>Medicine Code</th>
                                        <th>Medicine Name</th>
                                        <th>Strength</th>
                                        <th>Unit Type</th>
                                        <th>Batch Number</th>
                                        <th>Quantity</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="medicineRows">
                                    <tr>
                                        <td>
                                            <select name="medicine_code[]" class="form-control medicine-code" required>
                                                <option value="">-- Select Medicine --</option>
                                                <?php
                                                $res = mysqli_query($con, "SELECT medicine_code, medicine_name, strength, unit_type, batch_number FROM medicine_masters");
                                                while ($m = mysqli_fetch_assoc($res)) {
                                                    echo '<option 
                                                        value="'.$m['medicine_code'].'"
                                                        data-name="'.htmlspecialchars($m['medicine_name']).'"
                                                        data-strength="'.$m['strength'].'"
                                                        data-unit="'.$m['unit_type'].'"
                                                        data-batch="'.$m['batch_number'].'"
                                                    >'.htmlspecialchars($m['medicine_name']).' ('.$m['medicine_code'].')</option>';
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        <td><input type="text" name="medicine_name[]" class="form-control medicine-name" readonly></td>
                                        <td><input type="text" name="strength[]" class="form-control strength" readonly></td>
                                        <td><input type="text" name="unit_type[]" class="form-control unit_type" readonly></td>
                                        <td><input type="text" name="batch_number[]" class="form-control batch_number" readonly></td>
                                        <td><input type="number" name="quantity[]" class="form-control quantity" required></td>
                                        <td>
                                            <button type="button" class="btn btn-success addRow">Add</button>
                                            <button type="button" class="btn btn-danger removeRow">Remove</button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div><br>

                        <div class="row">
                                  <div class="col-md-6 mb-3">
                                <label>Manufacture Date</label>
                                <input type="date" id="manufacture_date"name="manufacture_date" class="form-control"  required>
                            </div>
                            <!-- Dates & Quantity -->
                            
                            <div class="col-md-6 mb-3">
                                <label>Expiry Date</label>
                                <input type="date" name="expiry_date" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>Purchase Rate</label>
                                <input type="number" step="0.01" name="purchase_rate" id="purchase_rate" class="form-control" oninput="calculateTotal()" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>Selling Price</label>
                                <input type="number" step="0.01" name="selling_price" class="form-control" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label>GST Amount</label>
                                <input type="number" step="0.01" name="gst_amount" id="gst_amount" class="form-control" oninput="calculateTotal()" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>Total Amount</label>
                                <input type="text" id="total_amount" name="total_amount" class="form-control" readonly>
                            </div>
                        </div>

                        <div class="text-end mt-3">
                            <button type="submit" name="submit" class="btn btn-primary">Add Stock</button>
                        </div>
                    </form>
                </div>

            </div>
            <?php include('include/footer.php'); ?>
        </div>
    </div>
</div>

<script>
// Auto-fill medicine details
$(document).on("change", ".medicine-code", function () {
    var selected = $(this).find("option:selected");
    var row = $(this).closest("tr");
    row.find(".medicine-name").val(selected.data("name") || "");
    row.find(".strength").val(selected.data("strength") || "");
    row.find(".unit_type").val(selected.data("unit") || "");
    row.find(".batch_number").val(selected.data("batch") || "");
});

// Add new row
$(document).on("click", ".addRow", function () {
    var newRow = $("#medicineRows tr:first").clone();
    newRow.find("input").val(""); 
    newRow.find("select").val("");
    $("#medicineRows").append(newRow);
});

// Remove row
$(document).on("click", ".removeRow", function () {
    if ($("#medicineRows tr").length > 1) {
        $(this).closest("tr").remove();
    }
});

// Calculate total amount
function calculateTotal() {
    var purchase = parseFloat($("#purchase_rate").val()) || 0;
    var gst = parseFloat($("#gst_amount").val()) || 0;
    $("#total_amount").val((purchase + gst).toFixed(2));
}
</script>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
</body>
</html>
