<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ========================
// Generate Next Vendor Code
// ========================
$result = mysqli_query($con, "SELECT vendor_code FROM vendor_masters 
    WHERE vendor_code LIKE 'VN%' 
    ORDER BY id DESC LIMIT 1");

if ($row = mysqli_fetch_assoc($result)) {
    $lastNumber = (int)substr($row['vendor_code'], 2);
    $newNumber  = $lastNumber + 1;
} else {
    $newNumber = 1;
}

$newVendorCode = "VN" . str_pad($newNumber, 3, "0", STR_PAD_LEFT);

// ========================
// Handle Form Submit
// ========================
if (isset($_POST['submit'])) {
    $vendor_name   = trim($_POST['vendor_name']);
    $vendor_code   = $_POST['vendor_code'];
    $Mobile_number = trim($_POST['Mobile_number']);
    $email_id      = trim($_POST['email_id']);
    $Gst_number    = trim($_POST['Gst_number']);
    $Street        = trim($_POST['Street']);
    $Area          = trim($_POST['Area']);
    $City          = trim($_POST['City']);
    $State         = trim($_POST['State']);
    $Pin_code      = trim($_POST['Pin_code']);

    $stmt = $con->prepare("INSERT INTO vendor_masters 
        (vendor_name, vendor_code, Mobile_number, email_id, Gst_number, Street, Area, City, State, Pin_code) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param(
        "ssssssssss",
        $vendor_name,
        $vendor_code,
        $Mobile_number,
        $email_id,
        $Gst_number,
        $Street,
        $Area,
        $City,
        $State,
        $Pin_code
    );

    if ($stmt->execute()) {
        echo "<script>alert('Vendor added successfully. Vendor Code: $vendor_code'); 
        window.location.href='manage-vendor.php';</script>";
    } else {
        echo "<script>alert('Error: Unable to add vendor');</script>";
    }

    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Pharmacy | Add Vendor</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>
<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>
        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle"> Add Vendor</h1>
                            </div>
                        </div>
                    </section>

                    <div class="container bg-white p-4 rounded shadow-sm">
                        <form method="post">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label>Vendor Name</label>
                                    <input type="text" name="vendor_name" class="form-control" placeholder="Enter Vendor Name" required onkeypress="return onlyLetters(event)">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Vendor Code</label>
                                    <input type="text" name="vendor_code" class="form-control" value="<?= $newVendorCode ?>" readonly>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Mobile Number</label>
                                    <input type="text" name="Mobile_number" class="form-control" placeholder="Enter Mobile Number" maxlength="10" required onkeypress="return onlyNumbers(event)">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Email ID</label>
                                    <input type="email" name="email_id" class="form-control" placeholder="Enter Email ID" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>GST Number</label>
                                    <input type="text" name="Gst_number" class="form-control" placeholder="Enter GST Number" maxlength="15" required onblur="validateGST(this)">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Street</label>
                                    <input type="text" name="Street" class="form-control" placeholder="Enter Street">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Area</label>
                                    <input type="text" name="Area" class="form-control" placeholder="Enter Area">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>City</label>
                                    <input type="text" name="City" class="form-control" placeholder="Enter City">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>State</label>
                                    <select name="State" id="State" class="form-control" required>
                                        <option value="">Select State</option>
                                        <option value="Tamil Nadu">Tamil Nadu</option>
                                        <option value="Kerala">Kerala</option>
                                        <option value="Karnataka">Karnataka</option>
                                        <option value="Maharashtra">Maharashtra</option>
                                        <option value="Delhi">Delhi</option>
                                        <option value="Gujarat">Gujarat</option>
                                      
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Pin Code</label>
                                    <input type="text" name="Pin_code" class="form-control" placeholder="Enter Pin Code" maxlength="6" required onkeypress="return onlyNumbers(event)">
                                </div>
                            </div>
                            <div class="text-end">
                                <button type="submit" name="submit" class="btn btn-primary">Add Vendor</button>
                            </div>
                        </form>
                    </div>
                </div>
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>

    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <script>
        // Only letters
        function onlyLetters(e) {
            var charCode = e.charCode || e.keyCode;
            return ((charCode >= 65 && charCode <= 90) || (charCode >= 97 && charCode <= 122) || charCode == 32);
        }

        // Only numbers
        function onlyNumbers(e) {
            var charCode = e.charCode || e.keyCode;
            return (charCode >= 48 && charCode <= 57);
        }

        // GST validation
        function validateGST(input) {
            var gstPattern = /^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}$/;
            if (!gstPattern.test(input.value)) {
                alert("Invalid GST Number. Format: 15 Alphanumeric (Eg: 22AAAAA0000A1Z5)");
                input.value = "";
                input.focus();
            }
        }
    </script>
</body>
</html>
