<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/config.php');

// Delete medicine
if (isset($_GET['delid']) && is_numeric($_GET['delid'])) {
    $id = intval($_GET['delid']);
    $stmt = $con->prepare("DELETE FROM medicine WHERE id = ?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        $_SESSION['msg'] = "Medicine deleted successfully.";
    } else {
        $_SESSION['msg'] = "Failed to delete medicine.";
    }
    $stmt->close();
    header("Location: expiry_tracking.php");
    exit;
}

// Expiry alert query
$expiryQuery = "
    SELECT * 
    FROM medicine 
    WHERE expiry_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY)
";
$expiryResult = $con->query($expiryQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
<title>  Add Medicine</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />
    <style>
        body { background: #f4f6f9; }
        .badge-expiry { font-size: 0.85rem; padding: 5px 8px; }
    </style>
</head>
<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>
        <div class="main-panel">
            <div class="content-wrapper">
                <section id="page-title" class="mb-3">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Pharmacy | Expiry Tracking</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid">

                    <!-- Session Alert -->
                    <?php if (!empty($_SESSION['msg'])): ?>
                        <div class="alert alert-info shadow-sm">
                            <?php echo htmlentities($_SESSION['msg']); unset($_SESSION['msg']); ?>
                        </div>
                    <?php endif; ?>

                    <!-- Expiry Alert -->
                    <?php if ($expiryResult && $expiryResult->num_rows > 0): ?>
                        <div class="alert alert-danger shadow-sm">
                            <i class="fa fa-exclamation-triangle me-2"></i>
                            <strong><?= $expiryResult->num_rows ?> medicine(s)</strong> expiring in the next 30 days!
                        </div>
                    <?php else: ?>
                        <div class="alert alert-success shadow-sm">
                            <i class="fa fa-check-circle me-2"></i> No medicines are nearing expiry in the next 30 days.
                        </div>
                    <?php endif; ?>

                    <!-- Medicines Table -->
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <i class="fa fa-pills me-2"></i> All Medicines
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="medicineTable" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Medicine Name</th>
                                            <th>Batch No</th>
                                                                                                                                    <th>Expiry Date</th>

                                            <th>Stock</th>
                                            <th>Category</th>

                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = mysqli_query($con, "SELECT * FROM medicine ORDER BY id DESC");
                                        $cnt = 1;
                                        while ($row = mysqli_fetch_assoc($sql)):
                                        ?>
                                            <tr>
                                                <td><?= $cnt++ ?></td>
                                                <td><?= htmlspecialchars($row['name']) ?></td>
                                                <td><?= htmlspecialchars($row['batch_no']) ?></td>
                                           <td>
    <?php
    $expiryDate = $row['expiry_date'];
    $now = time();
    $expiryTime = strtotime($expiryDate);

    if ($expiryTime < $now) {
        $dateBadgeClass = 'bg-danger';
        $statusBadgeClass = 'bg-danger';
        $statusText = 'Expired';
    } else {
        $dateBadgeClass = 'bg-success';
        $statusBadgeClass = 'bg-success';
        $statusText = 'Available';
    }
    ?>
    <span class="badge <?= $dateBadgeClass ?> badge-expiry">
        <?= htmlspecialchars($expiryDate) ?>
    </span>
</td>
                                                <td><?= htmlspecialchars($row['stock_quantity']) ?></td>
                                                <td><?= htmlspecialchars($row['category']) ?></td>
<!-- <td>
    <?php
    $expiryDate = $row['expiry_date'];
    $now = time();
    $expiryTime = strtotime($expiryDate);

    if ($expiryTime < $now) {
        $dateBadgeClass = 'bg-danger';
        $statusBadgeClass = 'bg-danger';
        $statusText = 'Expired';
    } else {
        $dateBadgeClass = 'bg-success';
        $statusBadgeClass = 'bg-success';
        $statusText = 'Available';
    }
    ?>
    <span class="badge <?= $dateBadgeClass ?> badge-expiry">
        <?= htmlspecialchars($expiryDate) ?>
    </span>
</td> -->
<td>
    <span class="badge <?= $statusBadgeClass ?>">
        <?= $statusText ?>
    </span>
</td>
                                                <td>
                                                    <a href="expiry_tracking.php?delid=<?= $row['id'] ?>"
                                                       class="btn btn-sm btn-outline-danger"
                                                       onclick="return confirm('Are you sure you want to delete this medicine?');">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php include('include/footer.php'); ?>
        </div>
    </div>
</div>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
</body>
</html>

