<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    echo "<script>alert('User not logged in!'); window.location.href='userindex.php';</script>";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
<title>Manage Vendors</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />
<style>
.detail_modal { width: 80%; }
table.dataTable thead th { color: #fff; background-color: #000; }
.no-print { display: none !important; }
</style>
</head>
<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>
        <div class="main-panel">
            <div class="content-wrapper">

                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8"><h1 class="mainTitle">Manage Vendors</h1></div>
                        <div class="col-sm-4 text-right">
                            <button onclick="printSection('print-area')" class="btn btn-primary">
                                <i class="mdi mdi-printer"></i> Print
                            </button>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <div id="print-area">
                                <table class="table table-striped table-bordered" id="vendorTable">
                                    <thead>
                                        <tr>
                                            <th>SNO</th>
                                            <th>Vendor Name</th>
                                            <th>Vendor Code</th>
                                            <th>Mobile</th>
                                            <th>Email</th>
                                            <th>GST No</th>
                                            <!-- <th>Action</th> -->
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $sql = mysqli_query($con, "SELECT * FROM vendor_masters ORDER BY id DESC");
                                    while ($row = mysqli_fetch_assoc($sql)):
                                    ?>
                                        <tr>
                                            <td></td>
                                            <td><?= htmlentities($row['vendor_name']); ?></td>
                                            <td><?= htmlentities($row['vendor_code']); ?></td>
                                            <td><?= htmlentities($row['Mobile_number']); ?></td>
                                            <td><?= htmlentities($row['email_id']); ?></td>
                                            <td><?= htmlentities($row['Gst_number']); ?></td>
                                            <!-- <td class="no-print">
                                                <a href="edit-vendor.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-warning"><i class="mdi mdi-pencil"></i></a>
                                                <a href="delete_vendor.php?id=<?= $row['id']; ?>" onclick="return confirm('Are you sure?');" class="btn btn-sm btn-danger"><i class="mdi mdi-delete"></i></a>
                                                <button class="btn btn-info btn-sm view-details"
                                                    data-toggle="modal"
                                                    data-target="#detailsModal"
                                                    data-supplier="<?= htmlentities($row['vendor_name']); ?>"
                                                    data-code="<?= htmlentities($row['vendor_code']); ?>"
                                                    data-mobile="<?= htmlentities($row['Mobile_number']); ?>"
                                                    data-email="<?= htmlentities($row['email_id']); ?>"
                                                    data-gst="<?= htmlentities($row['Gst_number']); ?>"
                                                    data-street="<?= htmlentities($row['Street']); ?>"
                                                    data-area="<?= htmlentities($row['Area']); ?>"
                                                    data-city="<?= htmlentities($row['City']); ?>"
                                                    data-state="<?= htmlentities($row['State']); ?>"
                                                    data-pincode="<?= htmlentities($row['Pin_code']); ?>"
                                                >View</button>
                                            </td> -->
                                        </tr>
                                    <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Details Modal -->
                <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg detail_modal" role="document">
                        <div class="modal-content">
                            <div class="modal-header bg-primary text-white">
                                <h5 class="modal-title">Vendor Details</h5>
                                <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <table class="table table-bordered">
                                    <tr><th>Supplier Name</th><td id="vSupplier"></td></tr>
                                    <tr><th>Vendor Code</th><td id="vCode"></td></tr>
                                    <tr><th>Mobile</th><td id="vMobile"></td></tr>
                                    <tr><th>Email</th><td id="vEmail"></td></tr>
                                    <tr><th>GST Number</th><td id="vGst"></td></tr>
                                    <tr><th>Street</th><td id="vStreet"></td></tr>
                                    <tr><th>Area</th><td id="vArea"></td></tr>
                                    <tr><th>City</th><td id="vCity"></td></tr>
                                    <tr><th>State</th><td id="vState"></td></tr>
                                    <tr><th>Pincode</th><td id="vPincode"></td></tr>
                                </table>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php include('include/footer.php'); ?>
        </div>
    </div>
</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="assets/vendors/js/vendor.bundle.base.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

<script>
$(document).ready(function() {
    var t = $('#vendorTable').DataTable({
        paging: true,
        lengthChange: true,
        searching: true,
        ordering: true,
        info: true,
        autoWidth: false,
        pageLength: 10,
        lengthMenu: [5, 10, 20, 50]
    });

    // Auto SNO
    t.on('order.dt search.dt', function () {
        t.column(0, { search:'applied', order:'applied' }).nodes().each(function(cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    // Fill modal
    $(document).on("click", ".view-details", function() {
        $("#vSupplier").text($(this).data("supplier"));
        $("#vCode").text($(this).data("code"));
        $("#vMobile").text($(this).data("mobile"));
        $("#vEmail").text($(this).data("email"));
        $("#vGst").text($(this).data("gst"));
        $("#vStreet").text($(this).data("street"));
        $("#vArea").text($(this).data("area"));  // corrected
        $("#vCity").text($(this).data("city"));
        $("#vState").text($(this).data("state"));
        $("#vPincode").text($(this).data("pincode"));
    });
});

// Print
function printSection(divId) {
    var printContents = document.getElementById(divId).innerHTML;
    var win = window.open('', '', 'height=700,width=900');
    win.document.write('<html><head><title>Vendor List</title>');
    win.document.write('<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css">');
    win.document.write('<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">');
    win.document.write('<style>table, th, td { border:1px solid black; border-collapse:collapse; padding:6px; }</style>');
    win.document.write('</head><body>');
    win.document.write('<h3 class="text-center">Vendor List</h3>');
    win.document.write(printContents);
    win.document.write('</body></html>');
    win.document.close();
    win.focus();
    win.print();
    win.close();
}
</script>
</body>
</html>
