<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Optional: check if user is logged in
if (!isset($_SESSION['id'])) {
    echo "<script>alert('User not logged in!'); window.location.href='userindex.php';</script>";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Pharmacy | View Inward Stock</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />
<style>
table.dataTable thead .sorting,
table.dataTable thead .sorting_asc,
table.dataTable thead .sorting_desc {
    cursor: pointer;
    background-color: black;
    color: white;
}
</style>
</head>
<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>
        <div class="main-panel">
            <div class="content-wrapper">

                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">View Inward Stock</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-striped table-bordered" id="inwardTable">
                                <thead>
                                    <tr>
                                        <th>SNO</th>
                                        <th>Invoice No</th>
                                        <th>Inward Date</th>
                                        <th>Vendor</th>
                                        <th>Medicine</th>
                                        <th>Batch No</th>
                                        <th>Manufacture Date</th>
                                        <th>Expiry Date</th>
                                        <th>Quantity</th>
                                        <th>Purchase Rate</th>
                                        <th>Selling Price</th>
                                        <th>GST</th>
                                        <th>Total Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $query = mysqli_query($con, "SELECT * FROM medicine_stock ORDER BY id DESC");
                                    while($row = mysqli_fetch_assoc($query)):
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td><?= htmlentities($row['invoice_no']); ?></td>
                                        <td><?= htmlentities($row['inward_date']); ?></td>
                                        <td><?= htmlentities($row['vendor_name']); ?></td>
                                        <td><?= htmlentities($row['medicine_name'].' ('.$row['medicine_code'].')'); ?></td>
                                        <td><?= htmlentities($row['batch_number']); ?></td>
                                        <td><?= htmlentities($row['manufacture_date']); ?></td>
                                        <td><?= htmlentities($row['expiry_date']); ?></td>
                                        <td><?= htmlentities($row['quantity']); ?></td>
                                        <td><?= htmlentities($row['purchase_rate']); ?></td>
                                        <td><?= htmlentities($row['selling_price']); ?></td>
                                        <td><?= htmlentities($row['gst_amount']); ?></td>
                                        <td><?= htmlentities($row['total_amount']); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <?php include('include/footer.php'); ?>
        </div>
    </div>
</div>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
$(document).ready(function() {
    var t = $('#inwardTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 10,
        "lengthMenu": [5, 10, 20, 50]
    });

    // Auto update SNO
    t.on('order.dt search.dt', function () {
        t.column(0, { search:'applied', order:'applied' }).nodes().each(function(cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
});
</script>
</body>
</html>
