<?php
session_start();
error_reporting(0);
include('include/config.php');
include('include/checklogin.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Profit/Loss Report</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
    <style>
        .btn-primary {
            margin-left : 980px;
        }
           
        </style>
</head>
<body>
    <div id="app">
        <?php include('include/sidebar.php'); ?>
        <div class="app-content">
            <?php include('include/header.php'); ?>
            <div class="main-content">
                <div class="wrap-content container" id="container">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Profit / Loss Report</h1>
                            </div>
                            <!-- <ol class="breadcrumb">
                                <li><span>Pharmacy</span></li>
                                <li class="active"><span>Profit / Loss Report</span></li>
                            </ol> -->
                        </div>
                    </section>
                    <a href="dashboard.php" class="btn btn-secondary mb-3">← Back to Dashboard</a>
                    <div class="container-fluid container-fullw bg-white">
                        <div class="row">
                        <div class="text-end mb-3">
						<button onclick="printSection('print-area')" class="btn btn-primary">
                            <i class="ti-printer"></i> Print
                        </button>
                    </div>
                            <div class="col-md-12">
                                <h5 class="over-title margin-bottom-15">Report <span class="text-bold">Profit or Loss</span></h5>
                                <div id="print-area">
                                <table class="table table-striped table-bordered" id="example1">
                                    <thead class="table-light">
                                        <tr>
                                            <th>SNO</th>
                                            <th>Invoice No</th>
                                            <th>Invoice Date</th>
                                            <th>Medicine</th>
                                            <th>Purchase Rate</th>
                                            <th>Selling Rate</th>
                                            <th>Quantity</th>
                                            <th>Profit / Loss</th>
                                        </tr>
                                    </thead>
                                    <tbody>
    <?php
    $cnt = 1;
    $total_profit = 0;
    $total_loss = 0;

    $sql = mysqli_query($con, "
        SELECT 
            i.invoice_no, 
            i.invoice_date, 
            m.name AS medicine_name, 
            m.rate AS purchase_rate, 
            ii.rate AS selling_rate, 
            ii.stock_quantity
        FROM 
            invoice_items ii 
        JOIN invoices i ON ii.invoice_id = i.id 
        JOIN medicine m ON ii.medicine_id = m.id
        WHERE DATE(i.invoice_date) = CURDATE()
    ");

    while ($row = mysqli_fetch_array($sql)) {
        $purchase_rate = $row['purchase_rate'];
        $selling_rate = $row['selling_rate'];
        $quantity = $row['stock_quantity'];
        $profit_or_loss = ($selling_rate - $purchase_rate) * $quantity;

        if ($profit_or_loss > 0) {
            $status = "<span class='text-success'>₹{$profit_or_loss} (Profit)</span>";
            $total_profit += $profit_or_loss;
        } elseif ($profit_or_loss < 0) {
            $status = "<span class='text-danger'>₹" . abs($profit_or_loss) . " (Loss)</span>";
            $total_loss += abs($profit_or_loss);
        } else {
            $status = "<span class='text-muted'>₹0 (No Profit/Loss)</span>";
        }
    ?>
    <tr>
        <td><?php echo $cnt++; ?>.</td>
        <td><?php echo $row['invoice_no']; ?></td>
        <td><?php echo $row['invoice_date']; ?></td>
        <td><?php echo $row['medicine_name']; ?></td>
        <td><?php echo $purchase_rate; ?></td>
        <td><?php echo $selling_rate; ?></td>
        <td><?php echo $quantity; ?></td>
        <td><?php echo $status; ?></td>
    </tr>
    <?php } ?>
</tbody>

<!-- Total Profit/Loss Summary Row -->
<tfoot>
    <tr>
        <th colspan="7" style="text-align: right;">Total Profit for Today:</th>
        <th><span class="text-success">₹<?php echo number_format($total_profit, 2); ?></span></th>
    </tr>
    <tr>
        <th colspan="7" style="text-align: right;">Total Loss for Today:</th>
        <th><span class="text-danger">₹<?php echo number_format($total_loss, 2); ?></span></th>
    </tr>
</tfoot>

                                </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include('include/footer.php'); ?>
        <?php include('include/setting.php'); ?>
    </div>

    <!-- JS Scripts -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function () {
            $('#example1').DataTable();
        });
    </script>
    <script>
        jQuery(document).ready(function () {
            Main.init();
            FormElements.init();
        });

  			function printSection(divId) {
    var printContents = document.getElementById(divId).innerHTML;
    var win = window.open('', '', 'height=700,width=900');
    win.document.write('<html><head><title>Appointment History</title>');
    win.document.write('<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">');
    win.document.write('<style>table { width: 100%; border-collapse: collapse; } table, th, td { border: 1px solid black; padding: 8px; }</style>');
    win.document.write('</head><body>');
    win.document.write('<h3 class="text-center">Appointment History</h3>');
    win.document.write(printContents);
    win.document.write('</body></html>');
    win.document.close();
    win.focus();
    win.print();
    win.close();
}
    </script>
</body>
</html>
