<?php
include('include/config.php');
session_start();

// Validate and sanitize invoice ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid invoice ID.");
}
$invoice_id = intval($_GET['id']);

// Fetch invoice details
$invoice = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM invoices WHERE id = $invoice_id"));
if (!$invoice) {
    die("Invoice not found.");
}

// Fetch invoice items
$items = mysqli_query($con, "
    SELECT ii.*, m.name AS medicine_name
    FROM invoice_items ii
    JOIN medicine m ON m.id = ii.medicine_id
    WHERE ii.invoice_id = $invoice_id
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice Details</title>
<link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
		<link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="assets/css/styles.css">
		<link rel="stylesheet" href="assets/css/plugins.css">
		<link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
	</head>
	<body>
		<div id="app">		
<?php include('include/sidebar.php');?>
<div class="app-content">
<?php include('include/header.php');?>
<div class="main-content" >
<div class="wrap-content container" id="container">
						<!-- start: PAGE TITLE -->
<section id="page-title">
<div class="row">
<div class="col-sm-8">
<h1 class="mainTitle">Pharmacy| Invoice Details</h1>
</div>
<!-- <ol class="breadcrumb">
<li>
<span>Admin</span>
</li>
<li class="active">
<span>View Patients</span>
</li>
</ol> -->
</div>
</section>   
 <!-- <style>
        @media print {
            .no-print { display: none; }
        }
    </style> -->
<a href="manage-invoice.php" class="btn btn-secondary mb-3">← Back to Manage invoice</a>

</head>
<body> 

<div class="container mt-5">
    <div class="invoice-box border rounded p-4 shadow-sm bg-white">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4>Invoice <?php echo htmlspecialchars($invoice['invoice_no']); ?></h4>
            <button onclick="window.print()" class="btn btn-primary no-print">Print Invoice</button>
        </div>

        <div class="row">
            <div class="col-md-6">
                <h6>Client Information</h6>
                <p><strong>Name:</strong> <?php echo htmlspecialchars($invoice['client_name']); ?></p>
                <p><strong>Contact:</strong> <?php echo htmlspecialchars($invoice['client_contact_no']); ?></p>
                <p><strong>Date:</strong> <?php echo htmlspecialchars($invoice['invoice_date']); ?></p>
            </div>
            <div class="col-md-6">
                <h6>Payment Details</h6>
                <p><strong>Type:</strong> <?php echo htmlspecialchars($invoice['payment_type']); ?></p>
                <p><strong>Place:</strong> <?php echo htmlspecialchars($invoice['payment_place']); ?></p>
                <p><strong>Status:</strong> <?php echo htmlspecialchars($invoice['payment_status']); ?></p>
            </div>
        </div>

        <hr>

        <h6>Invoice Items</h6>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Medicine</th>
                    <th>Rate (₹)</th>
                    <th>Quantity</th>
                    <th>Total (₹)</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($item = mysqli_fetch_assoc($items)): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['medicine_name']); ?></td>
                        <td><?php echo number_format($item['rate'], 2); ?></td>
                        <td><?php echo $item['stock_quantity']; ?></td>
                        <td><?php echo number_format($item['total_price'], 2); ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <hr>

        <!-- Invoice Breakdown -->
        <div class="row mt-4">
            <div class="col-md-6 offset-md-6">
                <table class="table table-bordered">
                    <tr>
                        <th>Sub Amount</th>
                        <td>₹<?php echo number_format($invoice['sub_amount'], 2); ?></td>
                    </tr>
                    <tr>
                        <th>Discount</th>
                        <td>₹<?php echo number_format($invoice['discount'], 2); ?></td>
                    </tr>
                    <tr>
                        <th>GST</th>
                        <td>₹<?php echo number_format($invoice['gst_amount'], 2); ?></td>
                    </tr>
                    <tr>
                        <th>Total Amount</th>
                        <td><strong>₹<?php echo number_format($invoice['total_amount'], 2); ?></strong></td>
                    </tr>
                    <tr>
                        <th>Paid</th>
                        <td>₹<?php echo number_format($invoice['paid_amount'], 2); ?></td>
                    </tr>
                    <tr>
                        <th>Due</th>
                        <td><strong>₹<?php echo number_format($invoice['due_amount'], 2); ?></strong></td>
                    </tr>
                </table>
            </div>
        </div>

    </div>
</div>

<!-- Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
		<!-- start: FOOTER -->
	<?php include('include/footer.php');?>
			<!-- end: FOOTER -->
		
			<!-- start: SETTINGS -->
	<?php include('include/setting.php');?>
			
			<!-- end: SETTINGS -->
		</div>
		<!-- start: MAIN JAVASCRIPTS -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
		<script src="vendor/modernizr/modernizr.js"></script>
		<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
		<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="vendor/switchery/switchery.min.js"></script>
		<!-- end: MAIN JAVASCRIPTS -->
		<!-- start: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
		<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
		<script src="vendor/autosize/autosize.min.js"></script>
		<script src="vendor/selectFx/classie.js"></script>
		<script src="vendor/selectFx/selectFx.js"></script>
		<script src="vendor/select2/select2.min.js"></script>
		<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
		<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
		<!-- end: JAVASCRIPTS REQUIRED FOR THIS PAGE ONLY -->
		<!-- start: CLIP-TWO JAVASCRIPTS -->
		<script src="assets/js/main.js"></script>
		<!-- start: JavaScript Event Handlers for this page -->
		<script src="assets/js/form-elements.js"></script>
		<script>
			jQuery(document).ready(function() {
				Main.init();
				FormElements.init();
			});
		</script>
		<!-- end: JavaScript Event Handlers for this page -->
		<!-- end: CLIP-TWO JAVASCRIPTS -->
	</body>
</html>
<?php  ?>