<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    header('location:logout.php');
    exit();
}

// =====================
// ACCEPT OR CANCEL APPOINTMENT
// =====================
if (isset($_GET['action']) && isset($_GET['id'])) {
    $appointmentId = intval($_GET['id']);
    $action = $_GET['action'];

    if ($action == "accept") {
        mysqli_query($con, "UPDATE appointment SET doctorStatus = 2 WHERE id = '$appointmentId'");
        $_SESSION['msg'] = "Appointment accepted successfully!";
    }

    if ($action == "cancel") {
        mysqli_query($con, "UPDATE appointment SET doctorStatus = 0 WHERE id = '$appointmentId'");
        $_SESSION['msg'] = "Appointment cancelled successfully!";
    }

    header("Location: appointment-history.php");
    exit();
}

// =====================
// DATE FILTER
// =====================
$from_date = !empty($_POST['from_date']) ? $_POST['from_date'] : '';
$to_date   = !empty($_POST['to_date']) ? $_POST['to_date'] : '';
$dateFilter = ($from_date && $to_date) ? " AND DATE(a.appointmentDate) BETWEEN '$from_date' AND '$to_date'" : "";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin | All Appointments</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">All Appointments</h1>
                        </div>
                    </div>
                </section>

                <!-- Date Filter -->
                <div class="container-fluid container-fullw bg-white">
                    <?php 
                    if(isset($_SESSION['msg'])) { 
                        echo "<div class='alert alert-success'>".$_SESSION['msg']."</div>"; 
                        unset($_SESSION['msg']);
                    } 
                    ?>
                    <form method="post" class="form-inline mb-4">
                        <label class="mr-2">From:</label>
                        <input type="date" name="from_date" class="form-control mr-3" value="<?= $from_date; ?>">
                        <label class="mr-2">To:</label>
                        <input type="date" name="to_date" class="form-control mr-3" value="<?= $to_date; ?>">
                        <button type="submit" class="btn btn-primary">Filter</button>
                        <a href="appointment-history.php" class="btn btn-danger ml-2">Reset</a>
                    </form>

                    <!-- Appointment Table -->
                    <div class="row">
                        <div class="col-md-12">
                            <table id="appointmentTable" class="table table-striped table-bordered">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Patient Name</th>
                                        <th>Doctor Name</th>
                                        <th>Reason</th>
                                        <th>Date & Time</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                $query = mysqli_query($con, "
                                    SELECT a.*, 
                                           u.fullName AS patientName, u.mobile_no, u.email, 
                                           u.address, u.city, u.pincode, u.age, a.reason,
                                           d.doctorName
                                    FROM appointment a
                                    JOIN users u ON u.id = a.userId 
                                    JOIN doctors d ON d.id = a.doctorId
                                    WHERE 1=1 $dateFilter
                                    ORDER BY a.appointmentDate DESC, a.appointmentTime ASC
                                ");

                                if (mysqli_num_rows($query) == 0) {
                                    echo "<tr><td colspan='6' class='text-center text-danger'>No appointments found.</td></tr>";
                                } else {
                                    while ($row = mysqli_fetch_assoc($query)) {
                                        if ($row['userStatus'] == 1 && $row['doctorStatus'] == 1) $status = "⏳ Pending";
                                        elseif ($row['userStatus'] == 0 && $row['doctorStatus'] == 1) $status = "❌ Cancelled by Patient";
                                        elseif ($row['doctorStatus'] == 0) $status = "❌ Cancelled by Doctor";
                                        elseif ($row['doctorStatus'] == 2) $status = "✅ Accepted by Doctor";
                                        else $status = "❌ Cancelled";

                                        echo "<tr>
                                            <td>".htmlentities($row['patientName'])."</td>
                                            <td>".htmlentities($row['doctorName'])."</td>
                                            <td>".htmlentities($row['reason'])."</td>
                                            <td>".htmlentities($row['appointmentDate'])." ".htmlentities($row['appointmentTime'])."</td>
                                            <td>".htmlentities($status)."</td>
                                            <td>";

                                        if ($row['userStatus'] == 1 && $row['doctorStatus'] == 1) {
                                            echo "<a href='appointment-history.php?action=accept&id=".$row['id']."' class='btn btn-success btn-sm' onclick=\"return confirm('Accept this appointment?');\">Accept</a> ";
                                            echo "<a href='appointment-history.php?action=cancel&id=".$row['id']."' class='btn btn-danger btn-sm' onclick=\"return confirm('Cancel this appointment?');\">Cancel</a>";
                                        } elseif ($row['doctorStatus'] == 2) {
                                            echo "<span class='badge badge-success'>Accepted</span>";
                                        } elseif ($row['doctorStatus'] == 0) {
                                            echo "<span class='badge badge-danger'>Cancelled</span>";
                                        } else {
                                            echo "<span class='badge badge-secondary'>Inactive</span>";
                                        }

                                        echo " 
                                            <button
                                                class='btn btn-info btn-sm view-details'
                                                data-toggle='modal'
                                                data-target='#detailsModal'
                                                data-patientid='".$row['userId']."'
                                                data-patient='".htmlentities($row['patientName'])."'
                                                data-doctor='".htmlentities($row['doctorName'])."'
                                                data-email='".htmlentities($row['email'])."'
                                                data-mobile='".htmlentities($row['mobile_no'])."'
                                                data-address='".htmlentities($row['address'])."'
                                                data-city='".htmlentities($row['city'])."'
                                                data-pincode='".htmlentities($row['pincode'])."'
                                                data-age='".htmlentities($row['age'])."'
                                                data-reason='".htmlentities($row['reason'])."'
                                                data-date='".htmlentities($row['appointmentDate'])."'
                                                data-time='".htmlentities($row['appointmentTime'])."'
                                                data-status='".htmlentities($status)."'
                                            >
                                                View
                                            </button>
                                        </td></tr>";
                                    }
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Details Modal -->
                <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header bg-primary text-white">
                                <h5 class="modal-title">Appointment & Prescription Details</h5>
                                <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <h5>Appointment Info</h5>
                                <table class="table table-bordered">
                                    <tr><th>Patient Name</th><td id="dPatient"></td></tr>
                                    <tr><th>Doctor Name</th><td id="dDoctor"></td></tr>
                                    <tr><th>Email</th><td id="dEmail"></td></tr>
                                    <tr><th>Mobile</th><td id="dMobile"></td></tr>
                                    <tr><th>Address</th><td id="dAddress"></td></tr>
                                    <tr><th>City</th><td id="dCity"></td></tr>
                                    <tr><th>Pincode</th><td id="dPincode"></td></tr>
                                    <tr><th>Age</th><td id="dAge"></td></tr>
                                    <tr><th>Reason</th><td id="dReason"></td></tr>
                                    <tr><th>Date</th><td id="dDate"></td></tr>
                                    <tr><th>Time</th><td id="dTime"></td></tr>
                                    <tr><th>Status</th><td id="dStatus"></td></tr>
                                </table>

                                <h5 class="mt-4">Prescription Info</h5>
                                <div id="prescriptionDetails">Loading...</div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS Libraries -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

<script>
$(document).ready(function () {
    $('#appointmentTable').DataTable();

    $(document).on("click", ".view-details", function() {
        $("#dPatient").text($(this).data("patient"));
        $("#dDoctor").text($(this).data("doctor"));
        $("#dEmail").text($(this).data("email"));
        $("#dMobile").text($(this).data("mobile")); 
        $("#dAddress").text($(this).data("address"));
        $("#dCity").text($(this).data("city"));
        $("#dPincode").text($(this).data("pincode"));
        $("#dAge").text($(this).data("age"));
        $("#dReason").text($(this).data("reason"));
        $("#dDate").text($(this).data("date"));
        $("#dTime").text($(this).data("time"));
        $("#dStatus").text($(this).data("status"));

        // Load prescription via AJAX
        var patientId = $(this).data("patientid");
        $("#prescriptionDetails").html("Loading...");
        $.get("fetch-prescription.php", { patient_id: patientId }, function(data) {
            $("#prescriptionDetails").html(data);
        });
    });
});
</script>
<script src="assets/js/main.js"></script>
</body>
</html>
