<?php
session_start();
include('include/config.php');

$searchResults = [];
$search = '';

if (isset($_GET['search'])) {
    $search = mysqli_real_escape_string($con, $_GET['search']);
    $query = "
        SELECT * FROM users
        WHERE fullName LIKE '%$search%' OR fullName LIKE '%$search%'
    ";
    $result = mysqli_query($con, $query);
    while ($row = mysqli_fetch_assoc($result)) {
        $searchResults[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Search Patients</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
		<link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="assets/css/styles.css">
		<link rel="stylesheet" href="assets/css/plugins.css">
		<link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>

<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                        </div>
                    </div>
                </section>
<body>
	       <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Reception | Search Patients</h1>
                        </div>
                    </div>
                </section>
 <div class="container mt-3">
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <input type="text" name="search" class="form-control w-100" placeholder="Search by name or contact" value="<?= htmlentities($search) ?>">
                            </div>
                        </div>
						<br>
                        <button type="submit" class="btn btn-primary mt-2">Search</button>
                    </form>

    <?php if ($search && count($searchResults) > 0): ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Full Name</th>
                    <th>Address</th>
                    <th>City</th>
                    <th>Gender</th>
                    <!-- <th>Username</th>
                    <th>Password</th>
                    <th>Reg Date</th>
                    <th>Updated On</th>
                    <th>Age</th>
                    <th>Blood Group</th>
                    <th>Country</th>
                    <th>Pincode</th> -->
					                    <th>Action</th>


                </tr>
            </thead>
            <tbody>
                <?php foreach ($searchResults as $row): ?>
                    <tr>
                        <td><?= htmlentities($row['id']) ?></td>
                        <td><?= htmlentities($row['fullName']) ?></td>
                        <td><?= htmlentities($row['address']) ?></td>
                        <td><?= htmlentities($row['city']) ?></td>
                        <td><?= htmlentities($row['gender']) ?></td>
                        <!-- <td><?= htmlentities($row['username']) ?></td>
                        <td><?= htmlentities($row['password']) ?></td>
                        <td><?= htmlentities($row['regDate']) ?></td>
                        <td><?= htmlentities($row['updationDate']) ?></td>
                        <td><?= htmlentities($row['age']) ?></td>
                        <td><?= htmlentities($row['bloodgroup']) ?></td>
                        <td><?= htmlentities($row['country']) ?></td>
                        <td><?= htmlentities($row['pincode']) ?></td> -->
						   <td>
												                                                <a href="edit_user.php?editid=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Edit"><i class="fa fa-pencil"></i></a>
<!-- <a href="view_user.php?viewid=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="View"><i class="fa fa-eye"></i></a> -->
                                                <a href="manage-users.php?delid=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Delete" onclick="return confirm('Are you sure you want to delete this user?');">
                                                    <i class="fa fa-trash" style="color:red;"></i>
                                                </a>
                                            </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php elseif ($search): ?>
        <div class="alert alert-warning">No patients found matching "<?= htmlentities($search) ?>".</div>
    <?php endif; ?>
</div>
</body>
</html>

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
<?php mysqli_close($con); ?>
