<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include('include/config.php');

// Handle delete request
if (isset($_GET['delid'])) {
    $delid = (int)$_GET['delid'];

    $stmt = mysqli_prepare($con, "DELETE FROM doctor_schedule WHERE id = ?");
    mysqli_stmt_bind_param($stmt, "i", $delid);
    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['msg'] = "Schedule deleted successfully.";
    } else {
        $_SESSION['msg'] = "Error deleting schedule.";
    }
    mysqli_stmt_close($stmt);

    header("Location: view_shedule.php");
    exit();
}

$schedules = mysqli_query($con, "SELECT * FROM doctor_schedule ORDER BY FIELD(available_day, 'Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday')");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | View Doctor Schedule</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>

        <div class="main-content">
            <div class="wrap-content container" id="container">
                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | View Doctor Schedule</h1>
                        </div>
                        <!-- <ol class="breadcrumb">
                            <li><span>Doctor</span></li>
                            <li class="active"><span>Schedule</span></li>
                        </ol> -->
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php
                    if (isset($_SESSION['msg'])) {
                        echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                        unset($_SESSION['msg']);
                    }
                    ?>
                    <div class="row">
                        <div class="col-md-12">
                            <table id="scheduleTable" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>NO</th>
                                        <th>Doctor Name</th>
                                        <th>Available Day</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $cnt = 1;
                                    while ($row = mysqli_fetch_assoc($schedules)) {
                                        ?>
                                        <tr>
                                            <td><?= $cnt++; ?></td>
                                            <td><?= htmlentities($row['doctor_name']); ?></td>
                                            <td><?= htmlentities($row['available_day']); ?></td>
                                            <td><?= date("g:i A", strtotime($row['start_time'])); ?></td>
                                            <td><?= date("g:i A", strtotime($row['end_time'])); ?></td>
                                            <td>
                                              <a href="edit_shedule.php?id=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Edit">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                    <a href="view_shedule.php?delid=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Delete" onclick="return confirm('Are you sure you want to delete this record?');">
                                                        <i class="fa fa-trash" style="color:red;"></i>
                                                    </a>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    if ($cnt === 1) {
                                        echo "<tr><td colspan='6' class='text-center'>No schedules found.</td></tr>";
                                    }
                                    ?>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS Libraries -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function () {
        $('#scheduleTable').DataTable();
    });

    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
<?php mysqli_close($con); ?>
