<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    header('location:logout.php');
    exit();
}

$doctorId = $_SESSION['id'];
$patient_id = isset($_GET['patient_id']) ? intval($_GET['patient_id']) : 0;

// Handle date filter (default today)
$from_date = $to_date = date('Y-m-d');
if (!empty($_POST['from_date']) && !empty($_POST['to_date'])) {
    $from_date = date('Y-m-d', strtotime($_POST['from_date']));
    $to_date   = date('Y-m-d', strtotime($_POST['to_date']));
}

$patientFilter = "";
if ($patient_id > 0) {
    $patientFilter = " AND a.userId = '$patient_id' ";
}

$dateFilter = "AND DATE(a.appointmentDate) BETWEEN '$from_date' AND '$to_date'";
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
<title>Doctor | Appointment History</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<style>
.detailsModal { width: 65%; }
.badge-success { color: #fff; background-color: #00cd08; }
</style>
</head>
<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>
        <div class="main-panel">
            <div class="content-wrapper">

                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Appointment History (Approved Only)</h1>
                        </div>
                    </div>
                </section>

                <!-- Date Filter -->
                <form method="post" class="form-inline mb-4">
                    <label class="mr-2">From:</label>
                    <input type="date" name="from_date" class="form-control mr-3" value="<?= $from_date; ?>">
                    <label class="mr-2">To:</label>
                    <input type="date" name="to_date" class="form-control mr-3" value="<?= $to_date; ?>">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    <a href="appointment-history.php" class="btn btn-danger ml-2">Reset</a>
                </form>

                <!-- Appointment Table -->
                <div class="row">
                    <div class="col-md-12">
                        <table id="appointmentTable" class="table table-striped table-bordered">
                            <thead class="thead-dark">
                                <tr>
                                    <th>SNO</th>
                                    <th>Patient Name</th>
                                    <th>Reason</th>
                                    <th>Appointment Date & Time</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = mysqli_query($con, "
                                    SELECT a.*, u.fullName AS patientName, u.mobile_no, u.email, u.address, u.city, u.pincode, u.age
                                    FROM appointment a
                                    JOIN users u ON u.id = a.userId 
                                    WHERE a.doctorId = '$doctorId'
                                          AND a.doctorStatus = 2
                                          $patientFilter
                                          $dateFilter
                                    ORDER BY a.appointmentDate DESC, a.appointmentTime ASC
                                ");

                                if (mysqli_num_rows($query) == 0) {
                                    echo "<tr><td colspan='6' class='text-center text-danger'>No approved appointments found for selected date range.</td></tr>";
                                } else {
                                    $cnt = 1;
                                    while ($row = mysqli_fetch_assoc($query)) {

                                        // Fetch latest patient vitals
                                        $vitalsQuery = mysqli_query($con, "
                                            SELECT * FROM patient_vitals 
                                            WHERE patient_id = " . intval($row['userId']) . " 
                                            ORDER BY created_at DESC 
                                            LIMIT 1
                                        ");
                                         $vitals = mysqli_fetch_assoc($vitalsQuery);

        $weight = isset($vitals['weight']) ? $vitals['weight'] . " kg" : '-';
        $height = isset($vitals['height']) ? $vitals['height'] . " cm" : '-';
        $temperature = isset($vitals['temperature']) ? $vitals['temperature'] . " °C" : '-';
        $bp = isset($vitals['blood_pressure']) ? $vitals['blood_pressure'] : '-';

                                        $timeAmPm = date('h:i A', strtotime($row['appointmentTime']));
                                        echo "<tr>
                                            <td>" . $cnt++ . "</td>
                                            <td>" . htmlentities($row['patientName']) . "</td>
                                            <td>" . htmlentities($row['reason']) . "</td>
                                            <td>" . date('d/m/Y', strtotime($row['appointmentDate'])) . " " . $timeAmPm . "</td>
                                            <td><span class='badge badge-success'>Approved</span></td>
                                            <td>
                                                <button
                                                    class='btn btn-info btn-sm view-details'
                                                    data-toggle='modal'
                                                    data-target='#detailsModal'
                                                    data-patientid='" . ($row['userId'] ?? 0) . "'
                                                    data-patient='" . htmlentities($row['patientName']) . "'
                                                    data-email='" . htmlentities($row['email']) . "'
                                                    data-mobile='" . htmlentities($row['mobile_no']) . "'
                                                    data-address='" . htmlentities($row['address']) . "'
                                                    data-city='" . htmlentities($row['city']) . "'
                                                    data-pincode='" . htmlentities($row['pincode']) . "'
                                                    data-age='" . htmlentities($row['age']) . "'
                                                    data-reason='" . htmlentities($row['reason']) . "'
                                                    data-date='" . date('d/m/Y', strtotime($row['appointmentDate'])) . "'
                                                    data-time='" . $timeAmPm . "'
                                                    data-weight='" . $weight . "'
                                                    data-height='" . $height . "'
                                                    data-temperature='" . $temperature . "'
                                                    data-bp='" . $bp . "'
                                                >
                                                    View
                                                </button>
                                            </td>
                                        </tr>";
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Details Modal -->
                <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg detailsModal" role="document" >
                        <div class="modal-content">
                            <div class="modal-header bg-primary text-white">
                                <h5 class="modal-title">Appointment & Vitals Details</h5>
                                <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                            </div>
                            <div class="modal-body">
                                <h5>Appointment Info</h5>
                                <table class="table table-bordered">
                                    <tr><th>Patient Name</th><td id="dPatient"></td></tr>
                                    <tr><th>Age</th><td id="dAge"></td></tr>
                                    <tr><th>Reason</th><td id="dReason"></td></tr>
                                    <tr><th>Email</th><td id="dEmail"></td></tr>
                                    <tr><th>Mobile</th><td id="dMobile"></td></tr>
                                    <tr><th>Address</th><td id="dAddress"></td></tr>
                                    <tr><th>City</th><td id="dCity"></td></tr>
                                    <tr><th>Pincode</th><td id="dPincode"></td></tr>
                                    <tr><th>Weight (kg)</th><td id="dWeight"></td></tr>
                                    <tr><th>Height (cm)</th><td id="dHeight"></td></tr>
                                    <tr><th>Temperature (°C)</th><td id="dTemperature"></td></tr>
                                    <tr><th>Blood Pressure</th><td id="dBP"></td></tr>
                                </table>

                                <h5 class="mt-4">Prescription Info</h5>
                                <div id="prescriptionDetails">Loading...</div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <?php include('include/footer.php'); ?>
        </div>
    </div>
</div>

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="assets/vendors/js/vendor.bundle.base.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
$(document).ready(function() {
    $('#appointmentTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 10,
        "lengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]]
    });

    $(document).on("click", ".view-details", function() {
        $("#dPatient").text($(this).data("patient"));
        $("#dEmail").text($(this).data("email"));
        $("#dMobile").text($(this).data("mobile"));
        $("#dAddress").text($(this).data("address"));
        $("#dCity").text($(this).data("city"));
        $("#dPincode").text($(this).data("pincode"));
        $("#dAge").text($(this).data("age"));
        $("#dReason").text($(this).data("reason"));
        $("#dWeight").text($(this).data("weight"));
        $("#dHeight").text($(this).data("height"));
        $("#dTemperature").text($(this).data("temperature"));
        $("#dBP").text($(this).data("bp"));

        var patientId = $(this).data("patientid");
        $("#prescriptionDetails").html("Loading...");
        $.get("fetch-prescription.php", { patient_id: patientId }, function(data) {
            $("#prescriptionDetails").html(data);
        });
    });
});
</script>
</body>
</html>
