<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Handle form submission
if (isset($_POST['submit'])) {
    $patient_id   = $_POST['fullName'];
    $doctorName   = $_POST['doctorName'];
    $date         = $_POST['round_date'];
    $notes        = $_POST['clinical_notes'];
    $invest       = $_POST['investigations'];
    $plan         = $_POST['treatment_plan'];

    // Get patient full name using ID
    $stmt = $con->prepare("SELECT fullName FROM users WHERE id = ?");
    $stmt->bind_param("i", $patient_id);
    $stmt->execute();
    $stmt->bind_result($fullName);
    $stmt->fetch();
    $stmt->close();

    // Insert into daily_rounds
    $stmt2 = $con->prepare("INSERT INTO daily_rounds (fullName, doctorName, round_date, clinical_notes, investigations, treatment_plan) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt2->bind_param("ssssss", $fullName, $doctorName, $date, $notes, $invest, $plan);

    if ($stmt2->execute()) {
        $_SESSION['msg'] = "✅ Daily round saved successfully.";
    } else {
        $_SESSION['msg'] = "❌ Error: " . $stmt2->error;
    }
    $stmt2->close();

    header("Location: view_dailyround.php"); // Prevent resubmission
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Doctor | Daily Round Entry</title>
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="vendor/fontawesome/css/font-awesome.min.css" rel="stylesheet">
    <link href="vendor/themify-icons/themify-icons.min.css" rel="stylesheet">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet">
    <link href="assets/css/styles.css" rel="stylesheet">
    <link href="assets/css/plugins.css" rel="stylesheet">
    <link href="assets/css/themes/theme-1.css" rel="stylesheet" id="skin_color" />
    <style>
        .btn-primary { width: 130px; height: 40px; }
    </style>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>

        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle text-primary">Daily Round Entry</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php if (!empty($_SESSION['msg'])): ?>
                        <div class="alert alert-info"><?= htmlentities($_SESSION['msg']); unset($_SESSION['msg']); ?></div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-12">
                 <form method="post" class="row g-3">
    <div class="col-md-6">
        <label class="form-label">Select Patient</label>
        <select name="fullName" class="form-control" required>
            <option value="">-- Select Patient --</option>
            <?php
            $result = mysqli_query($con, "SELECT id, fullName FROM users ORDER BY fullName");
            while ($row = mysqli_fetch_assoc($result)) {
                echo '<option value="' . $row['id'] . '">' . htmlentities($row['fullName']) . '</option>';
            }
            ?>
        </select>
    </div>

    <div class="col-md-6">
        <label class="form-label">Doctor Name</label>
        <select name="doctorName" class="form-control" required>
            <option value="">-- Select Doctor --</option>
            <?php
            $doctor_query = mysqli_query($con, "SELECT doctorName FROM doctors");
            while ($row = mysqli_fetch_assoc($doctor_query)) {
                echo '<option value="' . htmlentities($row['doctorName']) . '">' . htmlentities($row['doctorName']) . '</option>';
            }
            ?>
        </select>
    </div>

    <div class="col-md-6">
        <label class="form-label">Round Date</label>
        <input type="date" name="round_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Clinical Notes</label>
        <textarea name="clinical_notes" class="form-control" placeholder="Clinical Notes" required></textarea>
    </div>

    <div class="col-md-6">
        <label class="form-label">Investigations</label>
        <textarea name="investigations" class="form-control" placeholder="Investigations"></textarea>
    </div>

    <div class="col-md-6">
        <label class="form-label">Treatment Plan</label>
        <textarea name="treatment_plan" class="form-control" placeholder="Treatment Plan"></textarea>
    </div>

    <div class="col-12 mt-3">
        <button type="submit" name="submit" class="btn btn-primary">Save Round</button>
    </div>
</form>

                        </div>
                    </div>
                </div><!-- container-fullw -->
            </div>
        </div>
    </div>

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
