<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    echo "<script>alert('User not logged in!'); window.location.href='userindex.php';</script>";
    exit();
}

$docId = $_SESSION['id'];

// Dashboard counts
$todayCount = mysqli_fetch_array(
    mysqli_query($con, "SELECT COUNT(*) FROM appointment WHERE doctorId='$docId' AND doctorStatus=2 AND DATE(appointmentDate)=CURDATE()")
)[0];

$prescCount = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(*) FROM prescriptions"))[0];

// ===================
// Fetch appointments
// ===================
$appointments = mysqli_query($con, "
    SELECT a.op_id, a.appointmentDate, a.appointmentTime, a.userId, 
           a.reason,
           u.fullName, u.mobile_no, u.email, u.gender, u.address, u.age,
           d.doctorName
    FROM appointment a
    JOIN users u ON u.id = a.userId
    JOIN doctors d ON d.id = a.doctorId
    WHERE a.doctorId='$docId' 
      AND a.doctorStatus = 2
    ORDER BY a.appointmentDate, a.appointmentTime ASC
");

$events = [];
$bookedDates = [];
while ($row = mysqli_fetch_assoc($appointments)) {
    $timeAmPm = date("h:i A", strtotime($row['appointmentTime']));
    $time24   = date("H:i:s", strtotime($row['appointmentTime']));

    $events[] = [
        'id'    => $row['op_id'],
        'title' => $row['fullName'],
        'start' => $row['appointmentDate'] . "T" . $time24,
        'doctorName' => $row['doctorName'],
        'appointmentTime' => $timeAmPm,
        'mobile_no' => $row['mobile_no'],
        'email' => $row['email'],
        'gender' => $row['gender'],
                'age' => $row['age'],

        'address' => $row['address'],
        'reason' => $row['reason'],
        'patient_id' => $row['userId'],
        'hasPrescription' => false
    ];

    $bookedDates[] = $row['appointmentDate'];
}

// ===================
// Fetch doctor availability
// ===================
$availability = mysqli_query($con, "
    SELECT day_id, shift_type, start_time, end_time 
    FROM doctor_shift_master
    WHERE doc_id = '$docId'
");

$shiftEvents = [];
while ($row = mysqli_fetch_assoc($availability)) {
    $shiftEvents[] = [
        'title' => $row['shift_type'] . " Shift",
        'daysOfWeek' => [$row['day_id']],  // 0=Sunday, 1=Monday, etc.
        'startTime' => $row['start_time'],
        'endTime'   => $row['end_time'],
        'display'   => 'background',
        'color'     => '#28a745'
    ];
}

// Merge appointments + shifts
$allEvents = array_merge($events, $shiftEvents);

$bookedDates = array_unique($bookedDates);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Doctor | Reports</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />

    <style>
        body { background: #f4f6f9; font-family: 'Lato', sans-serif; }
        #calendar {
            max-width: 100%;
            margin: 20px auto;
            background: #fff;
            border-radius: 16px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        .fc-toolbar-title { font-size: 1.5rem; font-weight: 600; color: #333; }
        .fc-button { border-radius: 8px !important; padding: 6px 14px !important; font-size: 0.9rem; font-weight: 500; border: none !important; }
        .fc-button-primary { background: #7d4cacff !important; border-color: #693c8dff !important; }
        .fc-button-primary:hover { background: #5936a2 !important; }
        .fc-event {
            border-radius: 8px !important; font-size: 0.85rem; font-weight: 600;
            padding: 6px 10px; border: none !important;
            background-color: #6f42c1 !important; color: #fff !important;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        }
        .appointmentModal{
            width: 60%;
        }

        .fc-event:hover { transform: scale(1.05); box-shadow: 0 4px 10px rgba(0,0,0,0.2); }
        .fc-day-today { background: #e9f5ff !important; border: 1px solid #cfe2ff !important; }
        .card-custom {
            border-radius: 16px; color: #fff; padding: 25px;
            position: relative; overflow: hidden; cursor: pointer; transition: transform .2s;
        }
        .card-custom:hover { transform: scale(1.03); }
        .card-bg1 { background: linear-gradient(135deg, #6c4986ff, #7d59adff); }
        .card-bg3 { background: linear-gradient(135deg, #ffc107, #fd7e14); }
        .card-icon { font-size: 3rem; position: absolute; top: 20px; right: 20px; opacity: 0.2; }
        .dashboard-title { font-size: 1rem; font-weight: 600; margin-bottom: 5px; }
        .dashboard-count { font-size: 1.8rem; font-weight: 700; }
        .modal-body table { width: 100%; font-size: 0.95rem; }
        .modal-title { color: #fff; }
    </style>
</head>
<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>
        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Doctor | Reports</h1>
                            </div>
                        </div>
                    </section>

                    <!-- Dashboard Cards -->
                    <div class="row mt-4 g-4">
                        <div class="col-md-4">
                            <div class="card-custom card-bg1">
                                <i class="fa fa-calendar card-icon"></i>
                                <div class="dashboard-title">Today's Appointments</div>
                                <div class="dashboard-count"><?= $todayCount ?></div>
                                <a href="appointment-history.php?from_date=<?= date('Y-m-d') ?>&to_date=<?= date('Y-m-d') ?>" class="btn btn-light btn-sm mt-3">View Details</a>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card-custom card-bg3">
                                <i class="fa fa-file-text card-icon"></i>
                                <div class="dashboard-title">Total Prescriptions</div>
                                <div class="dashboard-count"><?= $prescCount ?></div>
                                <a href="view-prescription.php" class="btn btn-light btn-sm mt-3">View Prescriptions</a>
                            </div>
                        </div>
                    </div>

                    <!-- Calendar -->
                    <div id="calendar"></div>
                </div>
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>

    <!-- Appointment Modal -->
    <div class="modal fade" id="appointmentModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-xl appointmentModal" >
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Appointment Details & Patient History</h5>
                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h5>Appointment Info</h5>
                    <table class="table table-bordered">
                        <tr><th>Patient Name</th><td id="modalPatient"></td></tr>
                        <tr><th>Appointment Date</th><td id="modalDate"></td></tr>
                        <tr><th>Appointment Time</th><td id="modalTime"></td></tr>
                        <tr><th>Gender</th><td id="modalGender"></td></tr>
                                                <tr><th>Age</th><td id="modalage"></td></tr>

                        <tr><th>Address</th><td id="modalAddress"></td></tr>
                        <tr><th>Email</th><td id="modalEmail"></td></tr>
                        <tr><th>Mobile No</th><td id="modalMobile"></td></tr>
                        <tr><th>Reason</th><td id="modalReason"></td></tr>
                    </table>

                    <div class="text-right mt-3">
                        <button id="btnAddPrescription" class="btn btn-success">Add Prescription</button>
                        <button id="btnViewHistory" class="btn btn-info">Patient History</button>
                    </div>

                    <h5 class="mt-4">Patient History</h5>
<div id="patientHistory"></div>

                </div>
            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var events = <?php echo json_encode($allEvents); ?>;

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'timeGridDay',
                headerToolbar: { left: 'prev,next today', center: 'title', right: 'timeGridDay,timeGridWeek,dayGridMonth' },
                slotMinTime: "06:00:00",
                slotMaxTime: "22:00:00",
                events: events,
                eventTimeFormat: { hour: 'numeric', minute: '2-digit', hour12: true },

                eventContent: function(arg) {
                    if (arg.event.extendedProps.appointmentTime) {
                        return {
                            html: '<div style="white-space: normal; font-weight:600; font-size:0.85rem;">' +
                                  arg.event.title + '<br><span style="font-size:0.75rem;">' + arg.event.extendedProps.appointmentTime + '</span></div>'
                        };
                    } else {
                        return { html: arg.event.title }; // Shift title
                    }
                },

                eventClick: function(info) {
                    if (!info.event.extendedProps.appointmentTime) return; // Skip if it's a shift

                    $('#modalPatient').text(info.event.title);
                    $('#modalDate').text(info.event.startStr.split("T")[0]);
                    $('#modalTime').text(info.event.extendedProps.appointmentTime);
                    $('#modalGender').text(info.event.extendedProps.gender);
                                        $('#modalage').text(info.event.extendedProps.age);

                    $('#modalAddress').text(info.event.extendedProps.address);
                    $('#modalEmail').text(info.event.extendedProps.email);
                    $('#modalMobile').text(info.event.extendedProps.mobile_no);
                    $('#modalReason').text(info.event.extendedProps.reason);
                    

                    var appointmentId = info.event.id;
                    var patientId = info.event.extendedProps.patient_id;

                    $('#btnAddPrescription').off('click').on('click', function() {
                        window.location.href = 'prescription.php?appointment_id=' + appointmentId;
                    });

                    $('#btnViewHistory').off('click').on('click', function() {
                        $('#patientHistory').html('Loading...');
                        $.ajax({
                            url: 'get_patient_history.php',
                            type: 'POST',
                            data: { patient_id: patientId },
                            success: function(res) {
                                $('#patientHistory').html(res);
                                $('#btnViewHistory').hide();
                            },
                            error: function() {
                                $('#patientHistory').html('<p class="text-danger">Unable to load history.</p>');
                            }
                        });
                    });

                    $('#appointmentModal').modal('show');
                }
            });
            calendar.render();
        });
    </script>
</body>
</html>
