<?php
session_start();
include('include/config.php');
error_reporting(0);

if (!isset($_SESSION['id'])) {
    echo "<script>alert('User not logged in!'); window.location.href='doctor_index.php';</script>";
    exit();
}

$docId = $_SESSION['id'];

// Dashboard counts
$todayCount = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(*) FROM appointment WHERE doctorId='$docId' AND DATE(appointmentDate)=CURDATE()"))[0];
$labCount   = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(*) FROM lab_report"))[0];
$prescCount = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(*) FROM prescriptions"))[0];

// Fetch appointments for calendar
$appointments = mysqli_query($con, "
    SELECT a.op_id, a.appointmentDate, a.appointmentTime,a.userId, 
           u.fullName, u.mobile_no, u.email, u.gender, u.address, 
           d.doctorName
    FROM appointment a
    JOIN users u ON u.id = a.userId
    JOIN doctors d ON d.id = a.doctorId
    WHERE a.doctorId='$docId'
    ORDER BY a.appointmentDate, a.appointmentTime ASC
");

$events = [];
$bookedDates = [];

while ($row = mysqli_fetch_assoc($appointments)) {
    $timeAmPm = date("h:i A", strtotime($row['appointmentTime']));
    $time24   = date("H:i:s", strtotime($row['appointmentTime']));

    $events[] = [
        'id'    => $row['op_id'],
        'title' => $row['fullName'],
        'start' => $row['appointmentDate'] . "T" . $time24,
        'doctorName' => $row['doctorName'],
        'appointmentTime' => $timeAmPm,
        'mobile_no' => $row['mobile_no'],
        'email' => $row['email'],
        'gender' => $row['gender'],
        'address' => $row['address'],
        'patient_id' => $row['userId'],  // 👈 add this
        'hasPrescription' => false       // 👈 replace with query check if needed
    ];
    $bookedDates[] = $row['appointmentDate'];
}
$bookedDates = array_unique($bookedDates);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Doctor | Reports</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />

    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, rgb(240, 241, 243), #f3f4f6);
            min-height: 100vh;
            width: 100%;
            /* ✅ Fix */
            overflow-x: hidden;
            /* prevent horizontal scroll */
        }

        #calendar {
            max-width: 100%;
            margin: 20px auto;
            background: #fff;
            border-radius: 16px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .fc-toolbar-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #333;
        }

        .fc-button {
            border-radius: 8px !important;
            padding: 6px 14px !important;
            font-size: 0.9rem;
            font-weight: 500;
            border: none !important;
        }

        .fc-button-primary {
            background: #6f42c1 !important;
            border-color: #6f42c1 !important;
        }

        .fc-button-primary:hover {
            background: #5936a2 !important;
        }

        .fc-event {
            border-radius: 8px !important;
            font-size: 0.85rem;
            font-weight: 600;
            padding: 6px 10px;
            border: none !important;
            background-color: #6f42c1 !important;
            color: #fff !important;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }

        .fc-event:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .fc-day-today {
            background: #e9f5ff !important;
            border: 1px solid #cfe2ff !important;
        }

        .fc-event:hover {
            transform: scale(1.08);
            box-shadow: 0 6px 12px rgba(112, 9, 138, 0.2);
        }

        .card-custom {
            border-radius: 16px;
            color: #fff;
            padding: 25px;
            position: relative;
            overflow: hidden;
            cursor: pointer;
            transition: transform .2s;
        }

        .card-custom:hover {
            transform: scale(1.03);
        }

        .card-bg1 {
            background: linear-gradient(135deg, #6f42c1, #8e44ad);
            border-radius: 16px;
            color: #fff;
            padding: 25px;
            position: relative;
            overflow: hidden;
            cursor: pointer;
            transition: transform .2s;
        }

        .card-bg2 {
            background: linear-gradient(135deg, #28a745, #20c997);
            border-radius: 16px;
            color: #fff;
            padding: 25px;
            position: relative;
            overflow: hidden;
            cursor: pointer;
            transition: transform .2s;
        }

        .card-bg3 {
            background: linear-gradient(135deg, #ffc107, #fd7e14);
            border-radius: 16px;
            color: #fff;
            padding: 25px;
            position: relative;
            overflow: hidden;
            cursor: pointer;
            transition: transform .2s;
        }

        .card-icon {
            font-size: 3rem;
            position: absolute;
            top: 20px;
            right: 20px;
            opacity: 0.2;
        }

        .dashboard-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .dashboard-count {
            font-size: 1.8rem;
            font-weight: 700;
        }

        .modal-body table {
            width: 100%;
            font-size: 0.95rem;
        }

        .modal-title {
            color: #fff;
        }
    </style>
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="content-wrapper">
                <div class="page-header">
                    <h3 class="page-title"> Doctor | Reports </h3>
                </div>

                <!-- Dashboard Cards -->
                <div class="row g-4 mt-3">
                    <div class="col-md-4 col-sm-6">
                        <div class="card text-center card-bg1 p-4">
                            <i class="fa fa-calendar card-icon"></i>
                            <div class="dashboard-title">Today's Appointments</div>
                            <div class="dashboard-count"><?= $todayCount ?></div>
                            <a href="appointment-history.php?from_date=<?= date('Y-m-d') ?>&to_date=<?= date('Y-m-d') ?>" class="btn btn-sm bg-white btn-icon-text border">View Today</a>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <div class="card text-center card-bg2 p-4">
                            <i class="fa fa-flask card-icon"></i>
                            <div class="dashboard-title">Lab Reports</div>
                            <div class="dashboard-count"><?= $labCount ?></div>
                            <a href="view_reports.php" class="btn btn-sm bg-white btn-icon-text border">View Lab Reports</a>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <div class="card text-center card-bg3 p-4">
                            <i class="fa fa-file-text card-icon"></i>
                            <div class="dashboard-title">Total Prescriptions</div>
                            <div class="dashboard-count"><?= $prescCount ?></div>
                            <a href="view-prescription.php" class="btn btn-sm bg-white btn-icon-text border">View Prescriptions</a>
                        </div>
                    </div>
                </div>
                <?php


                // ✅ Appointment + Doctor + User join
                $docId = $_SESSION['id'];

                $sql = "
                    SELECT 
                    a.op_id,
                    a.doctorSpecialization,
                    a.doctorId,
                    a.userId,
                    a.appointmentDate,
                    a.appointmentTime,
                    d.doctorName,
                    u.fullName
                    FROM appointment a
                    JOIN doctors d ON a.doctorId = d.id
                    JOIN users u ON a.userId = u.id
                    WHERE a.doctorId = '$docId'
                    ORDER BY a.appointmentDate, a.appointmentTime
                    ";

                $result = mysqli_query($con, $sql);

                $events = [];
                $bookedDates = []; // ✅ store appointment dates
                while ($row = mysqli_fetch_assoc($result)) {
                    // Convert 24-hour time to 12-hour AM/PM
                    $timeAmPm = date("h:i A", strtotime($row['appointmentTime']));

                    // Store 24-hour time for FullCalendar ISO format
                    $time24 = date("H:i:s", strtotime($row['appointmentTime']));

                    $events[] = [
                        'id'    => $row['op_id'],
                        'title' => $row['fullName'] . ' (' . $timeAmPm . ')', // show AM/PM in title
                        'start' => $row['appointmentDate'] . "T" . $time24,    // FullCalendar needs 24-hour ISO time
                        'doctorName' => $row['doctorName'],
                        'appointmentTime' => $timeAmPm,                        // Pass AM/PM for tooltip
                        'color' => '#28a745'
                    ];

                    $bookedDates[] = $row['appointmentDate'];
                }

                $bookedDates = array_unique($bookedDates);
                ?>

                <!-- ✅ Calendar -->
                <div id="calendar"></div>
                <?php include('include/footer.php'); ?>

            </div> <!-- content-wrapper -->

        </div> <!-- main-panel -->
    </div> <!-- page-body-wrapper -->

    <!-- Scripts -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <!-- endinject -->
    <!-- Custom js for this page -->
    <script src="assets/js/dashboard.js"></script>
    <!-- End custom js for this page -->

    <!-- ✅ FullCalendar JS -->
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
            FormElements.init();
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            var bookedDates = <?php echo json_encode(array_values($bookedDates)); ?>;

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                events: <?php echo json_encode($events); ?>,

                eventContent: function(arg) {
                    let patientName = arg.event.title;
                    if (arg.view.type === "dayGridMonth" || arg.view.type === "timeGridWeek" || arg.view.type === "timeGridDay") {
                        return {
                            html: `<b>${patientName}</b>`
                        };
                    }
                },

                eventDidMount: function(info) {
                    let doctorName = info.event.extendedProps.doctorName;
                    let time = info.event.extendedProps.appointmentTime;
                    info.el.setAttribute("title", `Doctor: Dr. ${doctorName}\nTime: ${time}`);
                },

                // ✅ Highlight booked dates
                dayCellDidMount: function(info) {
                    let dateStr = info.date.toISOString().split("T")[0];
                    if (bookedDates.includes(dateStr)) {
                        info.el.style.backgroundColor = "#fff"; // light primary
                        info.el.style.borderRadius = "6px";
                    }
                }
            });

            calendar.render();
        });
    </script>
</body>

</html>