<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    header('location:logout.php');
    exit();
}

$doctorId = intval($_SESSION['id']);

// ✅ Fetch doctor details
$docQry = mysqli_query($con, "SELECT * FROM doctors WHERE id='$doctorId'");
$doctor = mysqli_fetch_assoc($docQry);

// ✅ Fetch doctor available shifts (with shift_type)
$shifts = [];
$shiftStmt = $con->prepare("SELECT day_id, shift_type, start_time, end_time 
                            FROM doctor_shift_master 
                            WHERE doc_id=? 
                            AND day_id BETWEEN 0 AND 4 
                            ORDER BY day_id ASC, FIELD(shift_type,'Morning','Afternoon','Evening','Night')");
$shiftStmt->bind_param("i", $doctorId);
$shiftStmt->execute();
$shiftRes = $shiftStmt->get_result();
while($row = $shiftRes->fetch_assoc()){
    $shifts[] = $row;
}

// ✅ Map day_id (0–4) to weekdays
$days = ['Monday','Tuesday','Wednesday','Thursday','Friday'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Doctor | Reports</title>
  <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
  <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
  <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
  <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
  <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>
<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>

    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>

        <div class="main-panel">
            <div class="content-wrapper">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor |  Info</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">

                    <!-- Doctor Info Card -->
                    <div class="card mb-4 shadow">
                        <div class="card-header bg-info text-white" style="font-size:20px;">Doctor Information</div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <tr><th>Name</th><td><?= htmlentities($doctor['doctorName']); ?></td></tr>
                                <tr><th>Specialization</th><td><?= htmlentities($doctor['specilization']); ?></td></tr>
                                <tr><th>Email</th><td><?= htmlentities($doctor['docEmail']); ?></td></tr>
                                <tr><th>Contact</th><td><?= htmlentities($doctor['contactno']); ?></td></tr>
                                <tr><th>Consultation Fees</th><td><?= htmlentities($doctor['docFees']); ?></td></tr>
                                <tr><th>City</th><td><?= htmlentities($doctor['city']); ?></td></tr>
                            </table>

                            <!-- Action Buttons -->
                            <!-- <div class="mt-3">
                                <a href="tel:<?= htmlentities($doctor['contactno']); ?>" class="btn btn-primary">📞 Call</a>
                                <a href="https://api.whatsapp.com/send?phone=<?= htmlentities($doctor['contactno']); ?>&text=Hello%20Doctor%20<?= urlencode($doctor['doctorName']); ?>" 
                                   target="_blank" class="btn btn-success">💬 WhatsApp</a>
                                <?php 
                                $videoCallLink = "https://meet.google.com/xyz-abcd-pqr"; 
                                ?>
                                <a href="<?= $videoCallLink; ?>" target="_blank" class="btn btn-danger">🎥 Video Call</a>
                            </div>
                        </div>
                    </div> -->
<br>
                    <!-- Doctor Available Timings Card -->
                    <div class="card mb-4 shadow">
                        <div class="card-header bg-success text-white" style="font-size:20px;">Doctor Available Timings (Mon–Fri)</div>
                        <br>
                        <div class="card-body">
                            <?php if(count($shifts) > 0) { ?>
                                <table id="shiftTable" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Day</th>
                                            <th>Shift</th>
                                            <th>Start Time</th>
                                            <th>End Time</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach($shifts as $s) { ?>
                                        <tr>
                                            <td><?= $days[$s['day_id']]; ?></td>
                                            <td><?= htmlentities($s['shift_type']); ?></td>
                                            <td><?= date("h:i A", strtotime($s['start_time'])); ?></td>
                                            <td><?= date("h:i A", strtotime($s['end_time'])); ?></td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            <?php } else { ?>
                                <div class="alert alert-warning">No available timings found for this doctor.</div>
                            <?php } ?>
                        </div>
                    </div>

                </div> <!-- container-fullw -->

            </div>
                <?php include('include/footer.php'); ?>

        </div>
    </div>
</div>

<!-- JS Libraries -->
<!-- JS -->
   <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function () {
        $('#shiftTable').DataTable();
    });
</script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
