<?php
session_start();
include('include/config.php');
error_reporting(0);

// Validate pid
if (!isset($_GET['pid']) || !is_numeric($_GET['pid'])) {
    die("Invalid or missing PID.");
}

$pid = intval($_GET['pid']);

// Fetch lab test entries for the given PID
$stmt = $con->prepare("SELECT id, test_name, notes FROM lab_tests WHERE pid = ?");
$stmt->bind_param("i", $pid);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("No lab tests found for this PID.");
}

// Process update
if (isset($_POST['submit'])) {
    foreach ($_POST['test_id'] as $index => $testId) {
        $testName = $_POST['test_name'][$index];
        $notes = $_POST['notes'][$index];

        $update = $con->prepare("UPDATE lab_tests SET test_name = ?, notes = ? WHERE id = ?");
        $update->bind_param("ssi", $testName, $notes, $testId);
        $update->execute();
    }

    echo "<script>alert('Lab test(s) updated successfully.');</script>";
    echo "<script>window.location.href='view-labtest.php';</script>";
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Lab Tests</title>
  <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet">
    <link href="vendor/select2/select2.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <!-- Page Title -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Nurse | Edit Lab Tests</h1>
                        </div>
                        <ol class="breadcrumb">
                            <li><span>Admin</span></li>
                            <li class="active"><span>Manage Nurses</span></li>
                        </ol>
                    </div>
                </section>
<div class="container mt-5">
    <form method="post">
        <?php while ($row = $result->fetch_assoc()): ?>
            <input type="hidden" name="test_id[]" value="<?= $row['id'] ?>">
            <div class="form-group">
                <label>Test Name</label>
                <input type="text" name="test_name[]" class="form-control" value="<?= htmlspecialchars($row['test_name']) ?>" required>
            </div>
            <div class="form-group">
                <label>Notes</label>
                <textarea name="notes[]" class="form-control" required><?= htmlspecialchars($row['notes']) ?></textarea>
            </div>
            <hr>
        <?php endwhile; ?>

        <button type="submit" name="submit" class="btn btn-primary">Update</button>
    </form>
</div>
</body>
</html>

            <?php include('include/footer.php'); ?>
        </div>
        <?php include('include/setting.php'); ?>
    </div>

    <!-- Scripts -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
</body>
</html>
