<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$selectedPatient = null;
$prescription_id = isset($_GET['prescription_id']) ? intval($_GET['prescription_id']) : 0;
$message = "";

// Fetch medicines
$medicineResult = mysqli_query($con, "SELECT name FROM medicine WHERE status='Available' ORDER BY name");

// Fetch patients for dropdown
$patients = $con->prepare("SELECT id, fullName FROM users ORDER BY fullName");
$patients->execute();
$patientResult = $patients->get_result();

// Fetch prescription data if editing
$prescription = [];
$itemsData = [];
if ($prescription_id) {
    $stmt = $con->prepare("SELECT * FROM prescriptions WHERE id = ?");
    $stmt->bind_param("i", $prescription_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $prescription = $result->fetch_assoc();
        $selectedPatient = ['patient_id' => $prescription['patient_id']];
    }
    $stmt->close();

    // Fetch prescription items
    $itemsResult = $con->prepare("SELECT * FROM prescription_items WHERE prescription_id = ?");
    $itemsResult->bind_param("i", $prescription_id);
    $itemsResult->execute();
    $items = $itemsResult->get_result();
    while ($row = $items->fetch_assoc()) {
        $itemsData[] = $row;
    }
    $itemsResult->close();
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $patient_id   = $_POST['patient_id'];
    $notes        = $_POST['notes'];
    $scan         = $_POST['scan'];
    $lab          = $_POST['lab'];
    $revisit_date = $_POST['revisit_date'];
    $posted_by    = $_SESSION['id'];

    if ($prescription_id) {
        // Update existing prescription
        $stmt = $con->prepare("UPDATE prescriptions SET patient_id=?, notes=?, posted_by=?, scan=?, lab=?, revisit_date=? WHERE id=?");
        $stmt->bind_param("isssssi", $patient_id, $notes, $posted_by, $scan, $lab, $revisit_date, $prescription_id);
        $stmt->execute();
        // Delete old items
        $con->query("DELETE FROM prescription_items WHERE prescription_id = $prescription_id");
    } else {
        // Insert new prescription
        $stmt = $con->prepare("INSERT INTO prescriptions (patient_id, notes, posted_by, scan, lab, revisit_date) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("isssss", $patient_id, $notes, $posted_by, $scan, $lab, $revisit_date);
        $stmt->execute();
        $prescription_id = $stmt->insert_id;
    }

    // Insert prescription items
    if (!empty($_POST['drug_name'])) {
        $item_stmt = $con->prepare("INSERT INTO prescription_items 
            (prescription_id, drug_name, strength, strength_unit, duration, duration_unit, dose, 
             morning, afternoon, evening, night, food_instruction) 
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

        for ($i = 0; $i < count($_POST['drug_name']); $i++) {
            $drug            = $_POST['drug_name'][$i];
            $strength        = $_POST['strength'][$i];
            $strength_unit   = $_POST['strength_unit'][$i];
            $duration        = $_POST['duration'][$i];
            $duration_unit   = $_POST['duration_unit'][$i];
            $dose            = $_POST['dose'][$i];
            $morning         = isset($_POST['morning'][$i]) ? 1 : 0;
            $afternoon       = isset($_POST['afternoon'][$i]) ? 1 : 0;
            $evening         = isset($_POST['evening'][$i]) ? 1 : 0;
            $night           = isset($_POST['night'][$i]) ? 1 : 0;
            $food_instruction = $_POST['food_instruction'][$i] ?? '';

            $item_stmt->bind_param(
                "isssissiiiss",
                $prescription_id,
                $drug,
                $strength,
                $strength_unit,
                $duration,
                $duration_unit,
                $dose,
                $morning,
                $afternoon,
                $evening,
                $night,
                $food_instruction
            );
            $item_stmt->execute();
        }
    }

    $message = "✅ Prescription saved successfully.";
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title><?= $prescription_id ? "Edit" : "Add" ?> Prescription</title>
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css">
<link rel="stylesheet" href="assets/css/style.css">
<style>.card-header{color:#0d6efd;}</style>
</head>
<body>
<div class="container-scroller">
<?php include('include/sidebar.php'); ?>
<div class="container-fluid page-body-wrapper">
<?php include('include/header.php'); ?>

<div class="main-panel">
<div class="content-wrapper">
<section id="page-title">
<div class="row">
<div class="col-sm-8">
<h1 class="mainTitle text-primary"><?= $prescription_id ? "Edit" : "Add" ?> Prescription</h1>
</div>
</div>
</section>

<div class="container-fluid container-fullw bg-white p-4">
<?php if(!empty($message)) : ?>
<div class="alert alert-info"><?= htmlentities($message); ?></div>
<?php endif; ?>

<div class="row">
<div class="col-md-12">
<form method="POST" class="row g-4">
<!-- Patient Selection -->
<div class="col-md-6">
<label class="form-label">Patient</label>
<?php if ($selectedPatient): 
    // Fetch patient name
    $stmtPatient = $con->prepare("SELECT fullName FROM users WHERE id = ?");
    $stmtPatient->bind_param("i", $selectedPatient['patient_id']);
    $stmtPatient->execute();
    $resPatient = $stmtPatient->get_result();
    $patientName = ($resPatient->num_rows > 0) ? $resPatient->fetch_assoc()['fullName'] : '';
    $stmtPatient->close();
?>
    <input type="hidden" name="patient_id" value="<?= $selectedPatient['patient_id'] ?>">
    <input type="text" class="form-control" value="<?= htmlentities($patientName) ?>" readonly>
<?php else: ?>
    <select name="patient_id" class="form-control" required>
        <option value="">-- Select Patient --</option>
        <?php while ($row = $patientResult->fetch_assoc()) : ?>
            <option value="<?= $row['id'] ?>" <?= isset($prescription['patient_id']) && $prescription['patient_id']==$row['id'] ? 'selected' : '' ?>>
                <?= htmlentities($row['fullName']) ?>
            </option>
        <?php endwhile; ?>
    </select>
<?php endif; ?>
</div>

<!-- Notes -->
<div class="col-md-6">
<label class="form-label fw-bold">Notes</label>
<textarea name="notes" class="form-control" rows="2" placeholder="Notes"><?= htmlentities($prescription['notes'] ?? '') ?></textarea>
</div>

<!-- Scan -->
<div class="col-md-4">
<label class="form-label fw-bold">Scan / X-ray</label>
<select name="scan" class="form-control">
<option value="">-- Select Scan --</option>
<?php
$scans = ['Chest X-ray','Abdominal X-ray','MRI','CT Scan','Ultrasound','Other'];
foreach($scans as $s){
    $sel = (isset($prescription['scan']) && $prescription['scan']==$s) ? 'selected' : '';
    echo "<option value=\"$s\" $sel>$s</option>";
}
?>
</select>
</div>

<!-- Lab -->
<div class="col-md-4">
<label class="form-label fw-bold">Lab Test / Blood Test</label>
<select name="lab" class="form-control">
<option value="">-- Select Lab Test --</option>
<?php
$labs = ['Complete Blood Count','Liver Function Test','Kidney Function Test','Blood Sugar','Lipid Profile','Other'];
foreach($labs as $l){
    $sel = (isset($prescription['lab']) && $prescription['lab']==$l) ? 'selected' : '';
    echo "<option value=\"$l\" $sel>$l</option>";
}
?>
</select>
</div>

<!-- Revisit Date -->
<div class="col-md-4">
<label class="form-label fw-bold">Revisit Date</label>
<input type="date" name="revisit_date" class="form-control" value="<?= htmlentities($prescription['revisit_date'] ?? '') ?>">
</div>

<!-- Prescription Items -->
<div class="col-12 mt-4">
<h5 class="card-header bg-light p-2 rounded">Prescription Items</h5>
<div id="medicine-container" class="mt-3">
<?php if(!empty($itemsData)): ?>
<?php foreach($itemsData as $index=>$item): ?>
<div class="medicine-group row g-3 align-items-center mb-3 border p-3 rounded bg-light">
<!-- Medicine selection -->
<div class="col-md-2">
<label class="form-label">Medicine</label>
<select name="drug_name[]" class="form-control" required>
<option value="">Select</option>
<?php
mysqli_data_seek($medicineResult, 0);
while ($med = mysqli_fetch_assoc($medicineResult)) {
$sel = ($med['name']==$item['drug_name']) ? 'selected' : '';
echo "<option value=\"{$med['name']}\" $sel>{$med['name']}</option>";
}
?>
</select>
</div>

<div class="col-md-1"><label class="form-label">Strength</label><input type="number" name="strength[]" class="form-control" value="<?= $item['strength'] ?>"></div>
<div class="col-md-1"><label class="form-label">Unit</label><select name="strength_unit[]" class="form-control"><option value="mg" <?= $item['strength_unit']=='mg'?'selected':''?>>mg</option><option value="ml" <?= $item['strength_unit']=='ml'?'selected':''?>>ml</option></select></div>
<div class="col-md-1"><label class="form-label">Duration</label><input type="text" name="duration[]" class="form-control" value="<?= $item['duration'] ?>"></div>
<div class="col-md-1"><label class="form-label">Unit</label><select name="duration_unit[]" class="form-control"><option value="Days" <?= $item['duration_unit']=='Days'?'selected':''?>>Days</option><option value="Weeks" <?= $item['duration_unit']=='Weeks'?'selected':''?>>Weeks</option></select></div>
<div class="col-md-1"><label class="form-label">Dose</label><input type="text" name="dose[]" class="form-control" value="<?= $item['dose'] ?>"></div>

<div class="col-md-3">
<label class="form-label">Timing</label><br>
<div class="form-check form-check-inline"><input type="checkbox" name="morning[<?= $index ?>]" class="form-check-input" <?= $item['morning']?'checked':''?>><label class="form-check-label">Morning</label></div>
<div class="form-check form-check-inline"><input type="checkbox" name="afternoon[<?= $index ?>]" class="form-check-input" <?= $item['afternoon']?'checked':''?>><label class="form-check-label">Afternoon</label></div>
<div class="form-check form-check-inline"><input type="checkbox" name="evening[<?= $index ?>]" class="form-check-input" <?= $item['evening']?'checked':''?>><label class="form-check-label">Evening</label></div>
<div class="form-check form-check-inline"><input type="checkbox" name="night[<?= $index ?>]" class="form-check-input" <?= $item['night']?'checked':''?>><label class="form-check-label">Night</label></div>
</div>

<div class="col-md-2">
<label class="form-label">Food Instruction</label>
<div class="form-check"><input class="form-check-input" type="radio" name="food_instruction[<?= $index ?>]" value="Before Food" <?= $item['food_instruction']=='Before Food'?'checked':''?>><label class="form-check-label">Before Food</label></div>
<div class="form-check"><input class="form-check-input" type="radio" name="food_instruction[<?= $index ?>]" value="After Food" <?= $item['food_instruction']=='After Food'?'checked':''?>><label class="form-check-label">After Food</label></div>
</div>

<div class="col-md-1 text-center"><label class="form-label d-block">&nbsp;</label><button type="button" class="btn btn-danger remove-btn w-100" onclick="removeMedicine(this)">X</button></div>
</div>
<?php endforeach; ?>
<?php else: ?>
<!-- Default empty medicine group -->
<div class="medicine-group row g-3 align-items-center mb-3 border p-3 rounded bg-light">
<div class="col-md-2">
<label class="form-label">Medicine</label>
<select name="drug_name[]" class="form-control" required>
<option value="">Select</option>
<?php
mysqli_data_seek($medicineResult, 0);
while ($med = mysqli_fetch_assoc($medicineResult)) {
echo "<option value=\"{$med['name']}\">{$med['name']}</option>";
}
?>
</select>
</div>
<div class="col-md-1"><label class="form-label">Strength</label><input type="number" name="strength[]" class="form-control"></div>
<div class="col-md-1"><label class="form-label">Unit</label><select name="strength_unit[]" class="form-control"><option value="mg">mg</option><option value="ml">ml</option></select></div>
<div class="col-md-1"><label class="form-label">Duration</label><input type="text" name="duration[]" class="form-control"></div>
<div class="col-md-1"><label class="form-label">Unit</label><select name="duration_unit[]" class="form-control"><option value="Days">Days</option><option value="Weeks">Weeks</option></select></div>
<div class="col-md-1"><label class="form-label">Dose</label><input type="text" name="dose[]" class="form-control"></div>
<div class="col-md-3">
<label class="form-label">Timing</label><br>
<div class="form-check form-check-inline"><input type="checkbox" name="morning[0]" class="form-check-input"><label class="form-check-label">Morning</label></div>
<div class="form-check form-check-inline"><input type="checkbox" name="afternoon[0]" class="form-check-input"><label class="form-check-label">Afternoon</label></div>
<div class="form-check form-check-inline"><input type="checkbox" name="evening[0]" class="form-check-input"><label class="form-check-label">Evening</label></div>
<div class="form-check form-check-inline"><input type="checkbox" name="night[0]" class="form-check-input"><label class="form-check-label">Night</label></div>
</div>
<div class="col-md-2">
<label class="form-label">Food Instruction</label>
<div class="form-check"><input class="form-check-input" type="radio" name="food_instruction[0]" value="Before Food" checked><label class="form-check-label">Before Food</label></div>
<div class="form-check"><input class="form-check-input" type="radio" name="food_instruction[0]" value="After Food"><label class="form-check-label">After Food</label></div>
</div>
<div class="col-md-1 text-center"><label class="form-label d-block">&nbsp;</label><button type="button" class="btn btn-danger remove-btn w-100" onclick="removeMedicine(this)">X</button></div>
</div>
<?php endif; ?>
</div>

<div class="mt-3">
<button type="button" class="btn btn-secondary" onclick="addMedicine()">+ Add Medicine</button>
<button type="submit" class="btn btn-primary"><?= $prescription_id ? "Update" : "Submit" ?> Prescription</button>
</div>

</form>
</div>
</div>
</div>
</div>
<?php include('include/footer.php'); ?>
</div>
</div>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
<script>
function addMedicine(){
    const container = document.getElementById("medicine-container");
    const newRow = container.children[0].cloneNode(true);
    newRow.querySelectorAll("input, select").forEach(el=>{
        if(el.type==="checkbox" || el.type==="radio") el.checked=false;
        else el.value="";
    });
    container.appendChild(newRow);
}

function removeMedicine(button){
    const container = document.getElementById("medicine-container");
    if(container.children.length>1) button.closest(".medicine-group").remove();
}
</script>
</body>
</html>
