<?php
session_start();
error_reporting(0);
include('include/config.php');

// Fetch admission data
if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $stmt = mysqli_prepare($con, "SELECT * FROM admissions WHERE id = ?");
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $data = mysqli_fetch_assoc($result);
    mysqli_stmt_close($stmt);

    if (!$data) {
        $_SESSION['msg'] = "❌ Admission not found.";
        header("Location: view_admitted.php");
        exit;
    }
}

// Handle update request
if (isset($_POST['update'])) {
    $patient_id = $_POST['patient_id'];
    $admission_date = $_POST['admission_date'];
    $admission_reason = $_POST['admission_reason'];
    $doctor_id = $_POST['doctor_id'];

    $upd_stmt = mysqli_prepare($con, "UPDATE admissions SET patient_id=?, admission_date=?, admission_reason=?, doctor_id=? WHERE id=?");
    mysqli_stmt_bind_param($upd_stmt, "issii", $patient_id, $admission_date, $admission_reason, $doctor_id, $id);

    if (mysqli_stmt_execute($upd_stmt)) {
        $_SESSION['msg'] = "✅ Admission updated successfully.";
    } else {
        $_SESSION['msg'] = "❌ Error updating admission.";
    }
    mysqli_stmt_close($upd_stmt);

    header("Location: view_admitted.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Admission</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Edit Admission</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php
                    if (isset($_SESSION['msg'])) {
                        echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                        unset($_SESSION['msg']);
                    }
                    ?>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="panel panel-white">
                                <div class="panel-heading">
                                    <h5 class="panel-title">Edit Admission Details</h5>
                                </div>
                                <div class="panel-body">
                                    <form method="POST">
                                        <!-- Patient -->
                                        <div class="form-group">
                                            <label>Patient Name</label>
                                            <select name="patient_id" class="form-control" required>
                                                <option value="">Select Patient</option>
                                                <?php
                                                $res = mysqli_query($con, "SELECT id, fullName FROM users ORDER BY fullName");
                                                while ($row = mysqli_fetch_assoc($res)) {
                                                    $selected = ($row['id'] == $data['patient_id']) ? 'selected' : '';
                                                    echo "<option value='{$row['id']}' $selected>" . htmlentities($row['fullName']) . "</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <!-- Admission Date -->
                                        <div class="form-group">
                                            <label>Admission Date</label>
                                            <input type="date" name="admission_date" class="form-control" value="<?= htmlentities($data['admission_date']); ?>" required>
                                        </div>

                                        <!-- Reason -->
                                        <div class="form-group">
                                            <label>Admission Reason</label>
                                            <textarea name="admission_reason" class="form-control" rows="3" required><?= htmlentities($data['admission_reason']); ?></textarea>
                                        </div>

                                        <!-- Doctor -->
                                        <div class="form-group">
                                            <label>Doctor</label>
                                            <select name="doctor_id" class="form-control" required>
                                                <option value="">Select Doctor</option>
                                                <?php
                                                $doc_query = mysqli_query($con, "SELECT id, doctorName FROM doctors ORDER BY doctorName");
                                                while ($doc = mysqli_fetch_assoc($doc_query)) {
                                                    $selected = ($doc['id'] == $data['doctor_id']) ? 'selected' : '';
                                                    echo "<option value='{$doc['id']}' $selected>" . htmlentities($doc['doctorName']) . "</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <button type="submit" name="update" class="btn btn-primary">Update Admission</button>
                                        <a href="view_admitted.php" class="btn btn-default">Cancel</a>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div><!-- container-fluid -->
            </div><!-- wrap-content -->
        </div><!-- main-content -->
    </div><!-- app-content -->

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div><!-- app -->

<!-- JS Libraries -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
