<?php
include('include/config.php');

if (isset($_GET['pid'])) {
    $pid = intval($_GET['pid']);
    $query = mysqli_query($con, "SELECT * FROM prescription_items WHERE prescription_id = '$pid'");

    if (mysqli_num_rows($query) == 0) {
        echo "<p class='text-danger'>No medicines added for this prescription.</p>";
    } else {
        echo "<table class='table table-sm table-bordered'>
                <thead class='thead-dark'>
                    <tr>
                        <th>Medicine</th>
                        <th>Strength</th>
                        <th>Dose</th>
                        <th>Duration</th>
                        <th>Food Advice</th>
                        <th>Morning</th>
                        <th>Afternoon</th>
                        <th>Evening</th>
                        <th>Night</th>
                    </tr>
                </thead>
                <tbody>";
        while ($row = mysqli_fetch_assoc($query)) {
            echo "<tr>
                    <td>".htmlentities($row['drug_name'])."</td>
                    <td>".htmlentities($row['strength'].' '.$row['strength_unit'])."</td>
                    <td>".htmlentities($row['dose'])."</td>
                    <td>".htmlentities($row['duration'].' '.$row['duration_unit'])."</td>
                    <td>".htmlentities($row['food_instruction'])."</td>
                    <td>".($row['morning'] ? '✅' : '❌')."</td>
                    <td>".($row['afternoon'] ? '✅' : '❌')."</td>
                    <td>".($row['evening'] ? '✅' : '❌')."</td>
                    <td>".($row['night'] ? '✅' : '❌')."</td>
                </tr>";
        }
        echo "</tbody>
        </table>";
    }
}
?>
