<?php
session_start();
include('include/config.php');
error_reporting(0);

// Handle delete request
if (isset($_GET['delid'])) {
    $delid = intval($_GET['delid']);
    $stmt = $con->prepare("DELETE FROM in_patient WHERE id = ?");
    $stmt->bind_param("i", $delid);
    if ($stmt->execute()) {
        $_SESSION['msg'] = "Patient deleted successfully!";
    } else {
        $_SESSION['msg'] = "Error deleting patient!";
    }
    $stmt->close();
    header("Location: manage-patient.php");
    exit;
}

// Load dropdown patients
$patients = $con->query("SELECT id, fullName FROM users ORDER BY fullName");

// Load doctor specializations
$specs = $con->query("SELECT specilization FROM doctorspecilization ORDER BY specilization");

// Handle add patient request (from modal)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_patient'])) {
    $Doctorspecialization = $_POST['Doctorspecialization'];
    $pid                  = (int)$_POST['fullName'];
    $patcontact           = $_POST['patcontact'];
    $patemail             = $_POST['patemail'];
    $gender               = $_POST['gender'];
    $pataddress           = $_POST['pataddress'];
    $state                = $_POST['state'];
    $city                 = $_POST['city'];

    // Get patient full name from users
    $stmt = $con->prepare("SELECT fullName FROM users WHERE id=?");
    $stmt->bind_param("i", $pid);
    $stmt->execute();
    $stmt->bind_result($fullName);
    $stmt->fetch();
    $stmt->close();

    // Insert patient record
    $ins = $con->prepare("INSERT INTO in_patient 
        (Doctorspecialization, fullName, patcontact, patemail, gender, pataddress, state, city) 
        VALUES (?,?,?,?,?,?,?,?)");
    $ins->bind_param("ssssssss", $Doctorspecialization, $fullName, $patcontact, $patemail, $gender, $pataddress, $state, $city);

    if ($ins->execute()) {
        $_SESSION['msg'] = "Patient added successfully!";
    } else {
        $_SESSION['msg'] = "Error: " . $ins->error;
    }
    $ins->close();
    header("Location: manage-patient.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | Manage In-Patients</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet"/>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row align-items-center">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Manage In-Patients</h1>
                        </div>
                        <div class="col-sm-4 text-right">
                            <button class="btn btn-primary" data-toggle="modal" data-target="#addPatientModal">
                                <i class="fa fa-plus"></i> Add Patient
                            </button>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php
                    if (isset($_SESSION['msg'])) {
                        echo '<div class="alert alert-info">'.htmlentities($_SESSION['msg']).'</div>';
                        unset($_SESSION['msg']);
                    }
                    ?>
                    <table class="table table-striped table-bordered" id="example1">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>Patient Name</th>
                            <th>Contact</th>
                            <th>Email</th>
                            <th>Gender</th>
                            <th>Address</th>
                            <th>State</th>
                            <th>City</th>
                            <th>Ward</th>
                            <th>Room No</th>
                            <th>Bed No</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        $sql = $con->query("SELECT ip.*, ra.room_no, ra.dname, ra.bed_no 
                                            FROM in_patient ip 
                                            LEFT JOIN room_allocation ra ON ra.patient_id = ip.id 
                                            ORDER BY ip.id DESC");
                        $cnt = 1;
                        while ($row = $sql->fetch_assoc()):
                        ?>
                            <tr>
                                <td><?= $cnt++; ?>.</td>
                                <td><?= htmlentities($row['fullName']); ?></td>
                                <td><?= htmlentities($row['patcontact']); ?></td>
                                <td><?= htmlentities($row['patemail']); ?></td>
                                <td><?= htmlentities($row['gender']); ?></td>
                                <td><?= htmlentities($row['pataddress']); ?></td>
                                <td><?= htmlentities($row['state']); ?></td>
                                <td><?= htmlentities($row['city']); ?></td>
                                <td><?= htmlentities($row['dname'] ?? 'Not Assigned'); ?></td>
                                <td><?= htmlentities($row['room_no'] ?? 'Not Assigned'); ?></td>
                                <td><?= htmlentities($row['bed_no'] ?? 'Not Assigned'); ?></td>
                                <td>
                                    <a href="edit-patient.php?id=<?= $row['id']; ?>" title="Edit">
                                        <i class="fa fa-pencil" style="color:#007bff;"></i>
                                    </a>
                                    &nbsp;&nbsp;
                                    <a href="manage-patient.php?delid=<?= $row['id']; ?>" title="Delete" onclick="return confirm('Are you sure?');">
                                        <i class="fa fa-trash" style="color:red;"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- ADD PATIENT MODAL -->
<div class="modal fade" id="addPatientModal" tabindex="-1" role="dialog" aria-labelledby="addPatientModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <form method="post">
        <div class="modal-header">
          <h5 class="modal-title" id="addPatientModalLabel">Add Patient</h5>
          <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        </div>
        <div class="modal-body row g-3">
          <div class="col-md-6">
              <label class="form-label">Doctor Specialization</label>
              <select name="Doctorspecialization" class="form-control" required>
                  <option value="">Select Specialization</option>
                  <?php while($s=$specs->fetch_assoc()): ?>
                      <option value="<?=htmlentities($s['specilization'])?>"><?=htmlentities($s['specilization'])?></option>
                  <?php endwhile; ?>
              </select>
          </div>
          <div class="col-md-6">
              <label class="form-label">Patient</label>
              <select name="fullName" class="form-control" required>
                  <option value="">-- Select Patient --</option>
                  <?php while($p=$patients->fetch_assoc()): ?>
                      <option value="<?=$p['id']?>"><?=htmlentities($p['fullName'])?></option>
                  <?php endwhile; ?>
              </select>
          </div>
          <div class="col-md-6">
              <label class="form-label">Contact</label>
<input type="text" name="patcontact" class="form-control" maxlength="10" 
       onkeypress="return /[0-9]/.test(event.key)" required>          </div>
          <div class="col-md-6">
              <label class="form-label">Email</label>
              <input type="email" name="patemail" class="form-control" required>
          </div>
          <div class="col-md-6">
              <label class="form-label">Gender</label>
              <select name="gender" class="form-control" required>
                  <option value="">Select</option>
                  <option value="Male">Male</option>
                  <option value="Female">Female</option>
                  <option value="Other">Other</option>
              </select>
          </div>
          <div class="col-md-6">
              <label class="form-label">Address</label>
              <textarea name="pataddress" class="form-control" rows="3" required></textarea>
          </div>
          <div class="col-md-6">
              <label class="form-label">State</label>
<input type="text" name="state" class="form-control" 
       onkeypress="return /[a-zA-Z\s]/.test(event.key)" required>          </div>
          <div class="col-md-6">
              <label class="form-label">City</label>
<input type="text" name="city" class="form-control" 
       onkeypress="return /[a-zA-Z\s]/.test(event.key)" required>          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" name="add_patient" class="btn btn-success">Save Patient</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- JS -->
 <script>
document.addEventListener("DOMContentLoaded", () => {
    document.querySelectorAll("input[name='state'], input[name='city']").forEach(inp => {
        inp.addEventListener("paste", e => {
            const paste = (e.clipboardData || window.clipboardData).getData('text');
            if (!/^[a-zA-Z\s]+$/.test(paste)) {
                e.preventDefault();
                alert("Only letters allowed!");
            }
        });
    });

    document.querySelector("input[name='patcontact']").addEventListener("paste", e => {
        const paste = (e.clipboardData || window.clipboardData).getData('text');
        if (!/^[0-9]+$/.test(paste)) {
            e.preventDefault();
            alert("Only numbers allowed!");
        }
    });
});
</script>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
$(document).ready(function () {
    $('#example1').DataTable();
});
</script>
<script src="assets/js/main.js"></script>
<script>
jQuery(document).ready(function() {
    Main.init();
});
</script>
</body>
</html>
