<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);

$selectedPatient = null;

if (isset($_GET['appointment_id'])) {
    $appId = intval($_GET['appointment_id']);
    $query = $con->prepare("
        SELECT u.id as patient_id, u.fullName
        FROM appointment a
        JOIN users u ON u.id = a.userId
        WHERE a.op_id = ?
    ");
    $query->bind_param("i", $appId);
    $query->execute();
    $result = $query->get_result();
    if ($result->num_rows > 0) {
        $selectedPatient = $result->fetch_assoc();
    }
    $query->close();
}

$message = "";

// Fetch medicines
$medicineResult = mysqli_query($con, "SELECT name FROM medicine WHERE status='Available' ORDER BY name");

// Fetch patients
$patients = $con->prepare("SELECT id, fullName FROM users ORDER BY fullName");
$patients->execute();
$patientResult = $patients->get_result();

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $patient_id   = $_POST['patient_id'];
    $notes        = $_POST['notes'];
    $scan         = $_POST['scan'];
    $lab          = $_POST['lab'];
    $revisit_date = $_POST['revisit_date'];
    $posted_by    = $_SESSION['id'];

    // Insert main prescription
    $stmt = $con->prepare("INSERT INTO prescriptions (patient_id, notes, posted_by, scan, lab, revisit_date) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssss", $patient_id, $notes, $posted_by, $scan, $lab, $revisit_date);
    if ($stmt->execute()) {
        $prescription_id = $stmt->insert_id;

        // Insert prescription items
        if (!empty($_POST['drug_name'])) {
            $item_stmt = $con->prepare("INSERT INTO prescription_items 
                (prescription_id, drug_name, strength, strength_unit, duration, duration_unit, dose, 
                 morning, afternoon, evening, night, food_instruction) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

            for ($i = 0; $i < count($_POST['drug_name']); $i++) {
                $drug            = $_POST['drug_name'][$i];
                $strength        = $_POST['strength'][$i];
                $strength_unit   = $_POST['strength_unit'][$i];
                $duration        = $_POST['duration'][$i];
                $duration_unit   = $_POST['duration_unit'][$i];
                $dose            = $_POST['dose'][$i];
                $morning         = isset($_POST['morning'][$i]) ? 1 : 0;
                $afternoon       = isset($_POST['afternoon'][$i]) ? 1 : 0;
                $evening         = isset($_POST['evening'][$i]) ? 1 : 0;
                $night           = isset($_POST['night'][$i]) ? 1 : 0;
                $food_instruction = $_POST['food_instruction'][$i] ?? '';

                $item_stmt->bind_param(
                    "isssissiiiss",
                    $prescription_id,
                    $drug,
                    $strength,
                    $strength_unit,
                    $duration,
                    $duration_unit,
                    $dose,
                    $morning,
                    $afternoon,
                    $evening,
                    $night,
                    $food_instruction
                );
                $item_stmt->execute();
            }
        }

        $message = "✅ Prescription saved successfully.";
    } else {
        $message = "❌ Error: " . $stmt->error;
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Doctor | Reports</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
    <style>
        .card-header {
            color: #0d6efd;
        }
        
    </style>
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="main-panel">
                <div class="content-wrapper">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle text-primary">Add Prescription</h1>
                            </div>
                        </div>
                    </section>

                    <div class="container-fluid container-fullw bg-white p-4">
                        <?php if (!empty($message)) : ?>
                            <div class="alert alert-info"><?= htmlentities($message); ?></div>
                        <?php endif; ?>

                        <div class="row">
                            <div class="col-md-12">
                                <form method="POST" class="row g-4">
                                    <!-- Patient Selection -->
                                    <div class="col-md-6">
                                        <label class="form-label">Patient</label>
                                        <?php if ($selectedPatient): ?>
                                            <input type="hidden" name="patient_id" value="<?= $selectedPatient['patient_id'] ?>">
                                            <input type="text" class="form-control" value="<?= htmlentities($selectedPatient['fullName']) ?>" readonly>
                                        <?php else: ?>
                                            <select name="patient_id" class="form-control" required>
                                                <option value="">-- Select Patient --</option>
                                                <?php while ($row = $patientResult->fetch_assoc()) : ?>
                                                    <option value="<?= $row['id'] ?>"><?= htmlentities($row['fullName']) ?></option>
                                                <?php endwhile; ?>
                                            </select>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Notes -->
                                    <div class="col-md-6">
                                        <label class="form-label fw-bold">Notes</label>
                                        <textarea name="notes" class="form-control" rows="2" placeholder="Notes"></textarea>
                                    </div>

                                    <!-- Scan -->
                                    <div class="col-md-4">
                                        <label class="form-label fw-bold">Scan / X-ray</label>
                                        <select name="scan" class="form-control">
                                            <option value="">-- Select Scan --</option>
                                            <option value="Chest X-ray">Chest X-ray</option>
                                            <option value="Abdominal X-ray">Abdominal X-ray</option>
                                            <option value="MRI">MRI</option>
                                            <option value="CT Scan">CT Scan</option>
                                            <option value="Ultrasound">Ultrasound</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div>

                                    <!-- Lab -->
                                    <div class="col-md-4">
                                        <label class="form-label fw-bold">Lab Test / Blood Test</label>
                                        <select name="lab" class="form-control">
                                            <option value="">-- Select Lab Test --</option>
                                            <option value="Complete Blood Count ">Complete Blood Count </option>
                                            <option value="Liver Function Test ">Liver Function Test </option>
                                            <option value="Kidney Function Test">Kidney Function Test </option>
                                            <option value="Blood Sugar">Blood Sugar</option>
                                            <option value="Lipid Profile">Lipid Profile</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div>

                                    <!-- Revisit Date -->
                                    <div class="col-md-4">
                                        <label class="form-label fw-bold">Revisit Date</label>
                                        <input type="date" name="revisit_date" class="form-control">
                                    </div>

                                    <!-- Prescription Items -->
                                    <div class="col-12 mt-4">
                                        <h5 class="card-header bg-light p-2 rounded">Prescription Items</h5>
                                        <div id="medicine-container" class="mt-3">
                                            <div class="medicine-group row g-3 align-items-center mb-3 border p-3 rounded bg-light">
                                                <div class="col-md-2">
                                                    <label class="form-label">Medicine</label>
                                                    <select name="drug_name[]" class="form-control" required>
                                                        <option value="">Select</option>
                                                        <?php
                                                        mysqli_data_seek($medicineResult, 0);
                                                        while ($med = mysqli_fetch_assoc($medicineResult)) : ?>
                                                            <option value="<?= htmlentities($med['name']) ?>"><?= htmlentities($med['name']) ?></option>
                                                        <?php endwhile; ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-1">
                                                    <label class="form-label">Strength</label>
                                                    <input type="number" name="strength[]" class="form-control" placeholder="100">
                                                </div>

                                                <div class="col-md-1">
                                                    <label class="form-label">Unit</label>
                                                    <select name="strength_unit[]" class="form-control">
                                                        <option value="mg">mg</option>
                                                        <option value="ml">ml</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-1">
                                                    <label class="form-label">Duration</label>
                                                    <input type="text" name="duration[]" class="form-control" placeholder="7">
                                                </div>

                                                <div class="col-md-1">
                                                    <label class="form-label">Unit</label>
                                                    <select name="duration_unit[]" class="form-control">
                                                        <option value="Days">Days</option>
                                                        <option value="Weeks">Weeks</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-1">
                                                    <label class="form-label">Dose</label>
                                                    <input type="text" name="dose[]" class="form-control" placeholder="1">
                                                </div>

                                                <div class="col-md-3">
                                                    <label class="form-label">Timing</label><br>
                                                    <div class="form-check form-check-inline">
                                                        <input type="checkbox" name="morning[0]" class="form-check-input">
                                                        <label class="form-check-label">Morning</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input type="checkbox" name="afternoon[0]" class="form-check-input">
                                                        <label class="form-check-label">Afternoon</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input type="checkbox" name="evening[0]" class="form-check-input">
                                                        <label class="form-check-label">Evening</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input type="checkbox" name="night[0]" class="form-check-input">
                                                        <label class="form-check-label">Night</label>
                                                    </div>
                                                </div>

                                                <div class="col-md-2">
                                                    <label class="form-label">Food Instruction</label>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio" name="food_instruction[0]" id="beforeFood0" value="Before Food" checked>
                                                        <label class="form-check-label" for="beforeFood0">Before Food</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio" name="food_instruction[0]" id="afterFood0" value="After Food">
                                                        <label class="form-check-label" for="afterFood0">After Food</label>
                                                    </div>
                                                </div>

                                                <div class="col-md-1 text-center">
                                                    <label class="form-label d-block">&nbsp;</label>
                                                    <button type="button" class="btn btn-danger remove-btn w-100" onclick="removeMedicine(this)">X</button>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mt-3">
                                            <button type="button" class="btn btn-secondary" onclick="addMedicine()">+ Add Medicine</button>
                                            <button type="submit" class="btn btn-primary">Submit Prescription</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- container-fullw -->


                </div>
                <?php include('include/footer.php'); ?>

            </div>
        </div>

    </div>

    <!-- Scripts -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <!-- endinject -->
    <!-- Custom js for this page -->
    <script src="assets/js/dashboard.js"></script>
    <script>
        function addMedicine() {
            const container = document.getElementById("medicine-container");
            const newRow = container.children[0].cloneNode(true);
            newRow.querySelectorAll("input, select").forEach(el => {
                if (el.type === "checkbox") el.checked = false;
                else el.value = "";
            });
            container.appendChild(newRow);

        }

        function removeMedicine(button) {
            const container = document.getElementById("medicine-container");
            if (container.children.length > 1) button.closest(".medicine-group").remove();
        }
    </script>
    <script>
        $(document).ready(function() {
            $(".main-navigation-menu li > a").click(function(e) {
                var parentLi = $(this).parent("li");

                // If this menu has a submenu
                if (parentLi.find(".sub-menu").length > 0) {
                    e.preventDefault(); // Prevent going to link

                    // Toggle submenu
                    parentLi.toggleClass("open");
                    parentLi.find(".sub-menu").slideToggle(200);

                    // Close other open menus (optional)
                    parentLi.siblings().removeClass("open").find(".sub-menu").slideUp(200);
                }
            });
        });
    </script>




    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendor/modernizr/modernizr.js"></script>
    <script src="vendor/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="vendor/switchery/switchery.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#example1').DataTable();
        });
    </script>
    <script src="assets/js/main.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
        });
    </script>
</body>

</html>