<?php
session_start();
include('include/config.php');
error_reporting(0);

// Handle delete action
if (isset($_GET['delid']) && is_numeric($_GET['delid'])) {
    $pid = intval($_GET['delid']);

    $stmt = $con->prepare("DELETE FROM lab_tests WHERE pid = ?");
    $stmt->bind_param("i", $pid);

    if ($stmt->execute()) {
        echo "<script>alert('Lab test(s) deleted successfully.');</script>";
        echo "<script>window.location.href='view-labtest.php';</script>";
        exit();
    } else {
        echo "<script>alert('Failed to delete lab test(s).');</script>";
    }
}

// Fetch grouped lab test entries
$sql = "
    SELECT 
        pid,
        GROUP_CONCAT(DISTINCT test_name ORDER BY test_name SEPARATOR ', ') AS test_names,
        GROUP_CONCAT(DISTINCT notes ORDER BY created_at SEPARATOR ', ') AS notes,
        MAX(created_at) AS created_at
    FROM lab_tests
    GROUP BY pid
";

$result = $con->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | View Lab Test Details</title>
     <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet">
    <link href="vendor/select2/select2.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <!-- Page Title -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor |View Lab Test Details</h1>
                        </div>
                        <!-- <ol class="breadcrumb">
                            <li><span>Admin</span></li>
                            <li class="active"><span>Manage Nurses</span></li>
                        </ol> -->
                    </div>
                </section>

                <div class="text-end mb-3">
                    <button onclick="printSection('print-area')" class="btn btn-primary">
                        <i class="ti-printer"></i> Print
                    </button>
                </div>

                <div id="print-area">
                    <div class="container-fluid container-fullw bg-white">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Prescription ID</th>
                                    <th>Test Names</th>
                                    <th>Notes</th>
                                    <th>Latest Entry Time</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if ($result && $result->num_rows > 0): ?>
                                <?php while ($row = $result->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['pid']) ?></td>
                                        <td><?= htmlspecialchars($row['test_names']) ?></td>
                                        <td><?= nl2br(htmlspecialchars($row['notes'])) ?></td>
                                        <td><?= htmlspecialchars($row['created_at']) ?></td>
                                        <td style="white-space: nowrap;">
                                            <a href="edit_labtest.php?pid=<?= $row['pid'] ?>" class="btn btn-transparent btn-xs" title="Edit">
                                                <i class="fa fa-pencil"></i>
                                            </a>
                                            <a href="view-labtest.php?delid=<?= $row['pid'] ?>" class="btn btn-transparent btn-xs" title="Delete" onclick="return confirm('Are you sure you want to delete all lab tests for this PID?');">
                                                <i class="fa fa-trash" style="color:red;"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5" class="text-center">No lab test records found.</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="col-lg-12 col-md-12">
                    <div class="panel panel-white"></div>
                </div>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script>
    function printSection(divId) {
        var printContents = document.getElementById(divId).innerHTML;
        var win = window.open('', '', 'height=700,width=900');
        win.document.write('<html><head><title>Print</title>');
        win.document.write('<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">');
        win.document.write('<style>table{width:100%;border-collapse:collapse}th,td{border:1px solid #000;padding:8px;text-align:left;}</style>');
        win.document.write('</head><body>');
        win.document.write(printContents);
        win.document.write('</body></html>');
        win.document.close();
        win.print();
    }
</script>
</body>
</html>
