<?php
session_start();
error_reporting(0);
include('include/config.php');
if (isset($_GET['delid'])) {
    $delid = intval($_GET['delid']);
    $del_stmt = mysqli_prepare($con, "DELETE FROM admissions WHERE id = ?");
    mysqli_stmt_bind_param($del_stmt, 'i', $delid);
    if (mysqli_stmt_execute($del_stmt)) {
        mysqli_stmt_close($del_stmt);
        $_SESSION['msg'] = "Test deleted successfully.";
    } else {
        $_SESSION['msg'] = "Error deleting test.";
    }
    // Redirect to avoid re-deletion on refresh
    header("Location: view_admitted.php");  // Change to your actual filename if different
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Hospital | View Admissions</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,600,700|Raleway:300,400,600,700" rel="stylesheet" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>

        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Hospital | View Admissions</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-striped table-bordered" id="admissionsTable">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Patient Name</th>
                                        <th>Admission Date</th>
                                        <th>Reason</th>
                                        <th>Doctor Name</th>
                                                                                <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT a.id, a.admission_date, a.admission_reason, u.fullName, d.doctorName
                                            FROM admissions a
                                            JOIN users u ON a.patient_id = u.id
                                            JOIN doctors d ON a.doctor_id = d.id
                                            ORDER BY a.admission_date DESC";
                                    $res = mysqli_query($con, $sql);
                                    $cnt = 1;
                                    while ($row = mysqli_fetch_array($res)) {
                                    ?>
                                    <tr>
                                        <td><?php echo $cnt++; ?></td>
                                        <td><?php echo htmlentities($row['fullName']); ?></td>
                                        <td><?php echo htmlentities($row['admission_date']); ?></td>
                                        <td><?php echo htmlentities($row['admission_reason']); ?></td>
                                        <td><?php echo htmlentities($row['doctorName']); ?></td>
                                        <td>
                                            <!-- <a href="view-patient.php?viewid=<?php echo $row['id']; ?>" title="View"><i class="fa fa-eye"></i></a> -->
                                            <a href="editadmit.php?id=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Edit"><i class="fa fa-pencil"></i></a>
                                            <a href="view_admitted.php?delid=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" title="Delete" 
                                               onclick="return confirm('Are you sure you want to delete this test?');">
                                               <i class="fa fa-trash" style="color:red;"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
        $('#admissionsTable').DataTable();
    });
</script>
</body>
</html>
