<?php
session_start();
include('include/config.php');

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "<div class='alert alert-danger'>Invalid ID</div>";
    exit;
}

$patient_id = intval($_GET['id']);
$result = mysqli_query($con, "SELECT * FROM ipd_requests  WHERE id = '$patient_id'");
$row = mysqli_fetch_assoc($result);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Patient | View Details</title>
    <meta charset="utf-8" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>

<body>
    <div id="app">		
        <?php include('include/sidebar.php'); ?>
        <div class="app-content">
            <?php include('include/header.php'); ?>
            
            <!-- Main Content -->
            <div class="main-content">
                <div class="wrap-content container" id="container">

                    <!-- Page Title -->
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Admitted Patient Details</h1>
                            </div>
                            <ol class="breadcrumb">
                                <li><span>Patient</span></li>
                                <li class="active"><span>View Details</span></li>
                            </ol>
                        </div>
                    </section>

                    <!-- Page Content -->
                    <div class="container-fluid container-fullw bg-white">
                        <div class="row">
                            <div class="col-md-12">
                                <?php if ($row) { ?>
                                    <table class="table table-bordered table-striped">
                                        <tr>
                                            <th>ID</th>
                                            <td><?php echo htmlentities($row['id']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Name</th>
                                            <td><?php echo htmlentities($row['patient_name']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Admission Date</th>
                                            <td><?php echo htmlentities($row['request_date']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Ward</th>
                                            <td><?php echo htmlentities($row['department']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Status</th>
                                            <td><?php echo htmlentities($row['status']); ?></td>
                                        </tr>
                                    </table>
                                    <a href="view_admitted.php" class="btn btn-secondary">← Back</a>
                                <?php } else { ?>
                                    <div class="alert alert-danger">No patient record found for ID <?php echo $patient_id; ?>.</div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <!-- Footer -->
            <?php include('include/footer.php'); ?>
        </div>

        <!-- Settings Panel -->
        <?php include('include/setting.php'); ?>
    </div>

    <!-- JavaScript Includes -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
        });
    </script>
</body>
</html>
