<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/config.php');

$selectedPatient = null;

if (isset($_GET['appointment_id'])) {
    $appId = intval($_GET['appointment_id']);
    $query = $con->prepare("
        SELECT u.id as patient_id, u.fullName
        FROM appointment a
        JOIN users u ON u.id = a.userId
        WHERE a.op_id = ?
    ");
    $query->bind_param("i", $appId);
    $query->execute();
    $result = $query->get_result();
    if ($result->num_rows > 0) {
        $selectedPatient = $result->fetch_assoc();
    }
    $query->close();
}

$message = "";

// Fetch medicines
$medicineResult = mysqli_query($con, "SELECT name FROM medicine WHERE status='Available' ORDER BY name");

// Fetch patients
$patients = $con->prepare("SELECT id, fullName FROM users ORDER BY fullName");
$patients->execute();
$patientResult = $patients->get_result();

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $patient_id   = $_POST['patient_id'];
    $notes        = $_POST['notes'] ?? '';
    $scan         = $_POST['scan'] ?? '';
    $lab          = $_POST['lab'] ?? '';
    $revisit_date = $_POST['revisit_date'] ?? '';
    $posted_by    = $_SESSION['id'];

    // Prescription image upload
    $prescription_image = null;
    if (isset($_FILES['prescription_image']) && $_FILES['prescription_image']['name'] != "") {
        $ext = pathinfo($_FILES['prescription_image']['name'], PATHINFO_EXTENSION);
        $prescription_image = "presc_" . time() . "." . $ext;
        move_uploaded_file($_FILES['prescription_image']['tmp_name'], "uploads/prescriptions/" . $prescription_image);
    }

    // Insert prescription
    $stmt = $con->prepare("INSERT INTO prescriptions (patient_id, notes, posted_by, scan, lab, revisit_date, prescription_image) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("issssss", $patient_id, $notes, $posted_by, $scan, $lab, $revisit_date, $prescription_image);

    if ($stmt->execute()) {
        $prescription_id = $stmt->insert_id;

        // Insert prescription items
        if (!empty($_POST['drug_name'])) {
            $item_stmt = $con->prepare("INSERT INTO prescription_items 
                (prescription_id, drug_name, strength, strength_unit, duration, duration_unit, dose, 
                 morning, afternoon, evening, night, food_instruction) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

            for ($i = 0; $i < count($_POST['drug_name']); $i++) {
                $drug            = $_POST['drug_name'][$i];
                $strength        = $_POST['strength'][$i];
                $strength_unit   = $_POST['strength_unit'][$i];
                $duration        = $_POST['duration'][$i];
                $duration_unit   = $_POST['duration_unit'][$i];
                $dose            = $_POST['dose'][$i];
                $morning         = isset($_POST['morning'][$i]) ? 1 : 0;
                $afternoon       = isset($_POST['afternoon'][$i]) ? 1 : 0;
                $evening         = isset($_POST['evening'][$i]) ? 1 : 0;
                $night           = isset($_POST['night'][$i]) ? 1 : 0;
                $food_instruction = $_POST['food_instruction'][$i] ?? '';

                $item_stmt->bind_param(
                    "isssissiiiss",
                    $prescription_id,
                    $drug,
                    $strength,
                    $strength_unit,
                    $duration,
                    $duration_unit,
                    $dose,
                    $morning,
                    $afternoon,
                    $evening,
                    $night,
                    $food_instruction
                );
                $item_stmt->execute();
            }
            $item_stmt->close();
        }

        $_SESSION['msg'] = "✅ Prescription saved successfully.";
    } else {
        $_SESSION['msg'] = "❌ Error: " . $stmt->error;
    }
    $stmt->close();
    header("Location: prescription.php"); // prevent form re-submission
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Doctor | Add Prescription</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    
</head>
<style>
        .remove-btn { margin-top: 32px; }
        h5{
            color: blue ;
        }
    </style>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle text-primary">Add Prescription</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php
                    if (isset($_SESSION['msg'])) {
                        echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                        unset($_SESSION['msg']);
                    }
                    ?>

                    <div class="row">
                        <div class="col-md-12">
                            <form method="POST" class="row g-3" enctype="multipart/form-data">
                                <!-- Patient Selection -->
                                <div class="col-md-6">
                                    <label class="form-label">Patient</label>
                                    <?php if ($selectedPatient): ?>
                                        <input type="hidden" name="patient_id" value="<?= $selectedPatient['patient_id'] ?>">
                                        <input type="text" class="form-control" value="<?= htmlentities($selectedPatient['fullName']) ?>" readonly>
                                    <?php else: ?>
                                        <select name="patient_id" class="form-control" required>
                                            <option value="">-- Select Patient --</option>
                                            <?php while ($row = $patientResult->fetch_assoc()) : ?>
                                                <option value="<?= $row['id'] ?>"><?= htmlentities($row['fullName']) ?></option>
                                            <?php endwhile; ?>
                                        </select>
                                    <?php endif; ?>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Notes</label>
                                    <textarea name="notes" class="form-control" placeholder="Notes"></textarea>
                                </div>

                                <div class="col-md-4">
                                    <label class="form-label">Scan / X-ray</label>
                                    <select name="scan" class="form-control">
                                        <option value="">-- Select Scan --</option>
                                        <option value="Chest X-ray">Chest X-ray</option>
                                        <option value="Abdominal X-ray">Abdominal X-ray</option>
                                        <option value="MRI">MRI</option>
                                        <option value="CT Scan">CT Scan</option>
                                        <option value="Ultrasound">Ultrasound</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>

                                <div class="col-md-4"> <label class="form-label">Lab Test / Blood Test</label> <select name="lab" class="form-control"> <option value="">-- Select Lab Test --</option> <option value="CBC">Complete Blood Count (CBC)</option> <option value="LFT">Liver Function Test (LFT)</option> <option value="KFT">Kidney Function Test (KFT)</option> <option value="Blood Sugar">Blood Sugar</option> <option value="Lipid Profile">Lipid Profile</option> <option value="Other">Other</option> </select> </div>

                                <div class="col-md-4">
                                    <label class="form-label">Revisit Date</label>
                                    <input type="date" name="revisit_date" class="form-control">
                                </div>

                                <!-- Prescription Items -->
                                <div class="col-12">
                                    <h5 class="card-header mt-3">Prescription Items</h5>
                                    <div id="medicine-container">
                                        <div class="medicine-group row mb-2">
                                            <div class="col-md-2">
                                                <select name="drug_name[]" class="form-control" required>
                                                    <option value="">Medicine</option>
                                                    <?php mysqli_data_seek($medicineResult, 0);
                                                    while ($med = mysqli_fetch_assoc($medicineResult)) : ?>
                                                        <option value="<?= htmlentities($med['name']) ?>"><?= htmlentities($med['name']) ?></option>
                                                    <?php endwhile; ?>
                                                </select>
                                            </div>
                                            <div class="col-md-1"><input type="number" name="strength[]" class="form-control" placeholder="Strength"></div>
                                            <div class="col-md-1">
                                                <select name="strength_unit[]" class="form-control">
                                                    <option value="mg">mg</option>
                                                    <option value="ml">ml</option>
                                                </select>
                                            </div>
                                            <div class="col-md-1"><input type="text" name="duration[]" class="form-control" placeholder="Duration"></div>
                                            <div class="col-md-1">
                                                <select name="duration_unit[]" class="form-control">
                                                    <option value="Days">Days</option>
                                                    <option value="Weeks">Weeks</option>
                                                </select>
                                            </div>
                                            <div class="col-md-1"><input type="text" name="dose[]" class="form-control" placeholder="Dose"></div>
                                            <div class="col-md-3">
                                                <label><input type="checkbox" name="morning[0]"> Morning</label>
                                                <label><input type="checkbox" name="afternoon[0]"> Afternoon</label>
                                                <label><input type="checkbox" name="evening[0]"> Evening</label>
                                                <label><input type="checkbox" name="night[0]"> Night</label>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label d-block">Food Instruction</label>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="food_instruction[0]" value="Before Food" checked>
                                                    <label class="form-check-label">Before Food</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="food_instruction[0]" value="After Food">
                                                    <label class="form-check-label">After Food</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">Prescription Image</label>
                                                <input type="file" name="prescription_image" class="form-control" accept="image/*">
                                            </div>
                                            <div class="col-md-1">
                                                <button type="button" class="btn btn-danger remove-btn" onclick="removeMedicine(this)">X</button>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <button type="button" class="btn btn-secondary mt-2" onclick="addMedicine()">+ Add Medicine</button>
                                    <button type="submit" class="btn btn-primary mt-2">Submit Prescription</button>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script>
function addMedicine() {
    const container = document.getElementById("medicine-container");
    const newRow = container.children[0].cloneNode(true);
    newRow.querySelectorAll("input, select").forEach((el, index) => {
        if (el.type === "checkbox" || el.type === "radio") el.checked = false;
        else el.value = "";
        if (el.name.includes('food_instruction')) el.name = `food_instruction[${container.children.length}]`;
    });
    container.appendChild(newRow);
}
function removeMedicine(button) {
    const container = document.getElementById("medicine-container");
    if (container.children.length > 1) button.closest(".medicine-group").remove();
}
</script>
<script>
$(document).ready(function () {
    $(".main-navigation-menu li > a").click(function (e) {
        var parentLi = $(this).parent("li");

        // If this menu has a submenu
        if (parentLi.find(".sub-menu").length > 0) {
            e.preventDefault(); // Prevent going to link

            // Toggle submenu
            parentLi.toggleClass("open");
            parentLi.find(".sub-menu").slideToggle(200);

            // Close other open menus (optional)
            parentLi.siblings().removeClass("open").find(".sub-menu").slideUp(200);
        }
    });
});
</script>

</body>
</html>
