<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    echo "<script>alert('User not logged in!'); window.location.href='userindex.php';</script>";
    exit();
}

$patientId = $_SESSION['id'];

// Fetch patient info for modal
$patientQuery = mysqli_query($con, "SELECT * FROM users WHERE id='$patientId'");
$patient = mysqli_fetch_assoc($patientQuery);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Patient | Medical History</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
    <style>
        .detail_modal {
            width: 80%;
        }
    </style>
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>
        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="main-panel">
                <div class="content-wrapper">

                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Patient Medical History</h1>
                            </div>
                        </div>
                    </section>

                    <div class="container-fluid container-fullw bg-white">

                        <div class="row">
                            <div class="col-md-12">
                                <table class="table table-striped table-bordered" id="historyTable">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>SNO</th>
                                            <th>Doctor Name</th>
                                            <th>Specialization</th>
                                            <th>Appointment Date</th>
                                            <th>Appointment Time</th>
                                            <th>Reason</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = mysqli_query($con, "
                                            SELECT a.*, d.doctorName, d.specilization, d.docFees
                                            FROM appointment a
                                            JOIN doctors d ON d.id = a.doctorId
                                            WHERE a.userId='$patientId'
                                            ORDER BY a.appointmentDate DESC, a.appointmentTime ASC
                                        ");
                                        while ($row = mysqli_fetch_assoc($sql)):
                                        ?>
                                            <tr>
                                                <td></td>
                                                <td><?= htmlentities($row['doctorName']); ?></td>
                                                <td><?= htmlentities($row['specilization']); ?></td>
                                                <td><?= date("d/m/Y", strtotime($row['appointmentDate'])); ?></td>
                                                <td><?= date("g:i A", strtotime($row['appointmentTime'])); ?></td>
                                                <td><?= htmlentities($row['reason']); ?></td>
                                                <td>
                                                    <button class="btn btn-info btn-sm view-details"
                                                        data-toggle="modal"
                                                        data-target="#detailsModal"
                                                        data-appointmentid="<?= $row['id']; ?>"
                                                        data-doctor="<?= htmlentities($row['doctorName']); ?>"
                                                        data-spec="<?= htmlentities($row['specilization']); ?>"
                                                        data-fee="<?= htmlentities($row['docFees']); ?>"
                                                        data-date="<?= date("d/m/Y", strtotime($row['appointmentDate'])); ?>"
                                                        data-time="<?= date("g:i A", strtotime($row['appointmentTime'])); ?>"
                                                        data-reason="<?= htmlentities($row['reason']); ?>">View History</button>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Details Modal -->
                    <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-xl detail_modal" role="document">
                            <div class="modal-content">
                                <div class="modal-header bg-primary text-white">
                                    <h5 class="modal-title">Patient Medical History</h5>
                                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">

                                    <h5 class="mt-3">Appointment Info</h5>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Doctor Name</th>
                                            <td id="dDoctor"></td>
                                        </tr>
                                        <tr>
                                            <th>Specialization</th>
                                            <td id="dSpec"></td>
                                        </tr>
                                        <tr>
                                            <th>Consultancy Fees</th>
                                            <td id="dFee"></td>
                                        </tr>
                                        <tr>
                                            <th>Appointment Date</th>
                                            <td id="dDate"></td>
                                        </tr>
                                        <tr>
                                            <th>Appointment Time</th>
                                            <td id="dTime"></td>
                                        </tr>
                                        <tr>
                                            <th>Reason</th>
                                            <td id="dReason"></td>
                                        </tr>
                                    </table>

                                    <h5 class="mt-3">Prescription Info</h5>
                                    <div id="prescriptionDetails">Loading...</div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function() {
            var t = $('#historyTable').DataTable({
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "pageLength": 10,
                "lengthMenu": [5, 10, 20, 50]
            });

            // Auto update SNO column
            t.on('order.dt search.dt', function () {
                t.column(0, { search:'applied', order:'applied' }).nodes().each(function(cell, i) {
                    cell.innerHTML = i + 1;
                });
            }).draw();

            // View details modal
            $(document).on("click", ".view-details", function() {
                $("#dDoctor").text($(this).data("doctor"));
                $("#dSpec").text($(this).data("spec"));
                $("#dFee").text($(this).data("fee") + " rs");
                $("#dDate").text($(this).data("date"));
                $("#dTime").text($(this).data("time"));
                $("#dReason").text($(this).data("reason"));

                var appointmentId = $(this).data("appointmentid");
                var patientId = "<?= $patientId ?>";

                $("#prescriptionDetails").html("Loading...");
                $.get("fetch-prescription.php", {
                    appointment_id: appointmentId,
                    patient_id: patientId
                }, function(data) {
                    $("#prescriptionDetails").html(data);
                });
            });
        });
    </script>

</body>
</html>
