<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    header('location:logout.php');
    exit();
}

// Handle delete request
if (isset($_GET['delid'])) {
    $delid = intval($_GET['delid']);

    // Delete related items first
    $stmt_items = mysqli_prepare($con, "DELETE FROM prescription_items WHERE prescription_id = ?");
    mysqli_stmt_bind_param($stmt_items, 'i', $delid);
    mysqli_stmt_execute($stmt_items);
    mysqli_stmt_close($stmt_items);

    // Delete prescription itself
    $stmt_prescription = mysqli_prepare($con, "DELETE FROM prescriptions WHERE id = ?");
    mysqli_stmt_bind_param($stmt_prescription, 'i', $delid);
    if (mysqli_stmt_execute($stmt_prescription)) {
        $_SESSION['msg'] = "Prescription deleted successfully.";
    } else {
        $_SESSION['msg'] = "Error deleting prescription.";
    }
    mysqli_stmt_close($stmt_prescription);

    header("Location: view-prescription.php");
    exit;
}

$from_date = $to_date = "";
$filterQuery = "";
if (!empty($_POST['from_date']) && !empty($_POST['to_date'])) {
    $from_date = $_POST['from_date'];
    $to_date   = $_POST['to_date'];
    $filterQuery = "WHERE DATE(p.created_at) BETWEEN '$from_date' AND '$to_date'";
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Patient | View Prescriptions</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
</head>

<body>
    <div id="app">
        <?php include('include/sidebar.php'); ?>
        <div class="app-content">
            <?php include('include/header.php'); ?>
            <div class="main-content">
                <div class="wrap-content container" id="container">

                    <!-- PAGE TITLE -->
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Patient | View Prescriptions</h1>
                            </div>
                        </div>
                    </section>

                    <div class="container-fluid container-fullw bg-white">
                        <?php
                        if (isset($_SESSION['msg'])) {
                            echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                            unset($_SESSION['msg']);
                        }
                        ?>

                        <!-- Date Filter -->
                        <form method="post" class="form-inline mb-4">
                            <label class="mr-2">From:</label>
                            <input type="date" name="from_date" class="form-control mr-3" value="<?= $from_date; ?>">
                            <label class="mr-2">To:</label>
                            <input type="date" name="to_date" class="form-control mr-3" value="<?= $to_date; ?>">
                            <button type="submit" class="btn btn-primary">Filter</button>
                            <a href="view-prescription.php" class="btn btn-danger ml-2">Reset</a>
                        </form>

                        <div class="row">
                            <div class="col-md-12">
                                <table class="table table-striped table-bordered" id="prescriptionTable">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>No</th>
                                            <th>Patient</th>
                                            <th>Notes</th>
                                            <th>Revisit Date</th>
                                            <th>Created On</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $query = "
    SELECT 
        p.id AS pid,
        u.fullName AS pname,
        p.notes,
        p.scan,
        p.lab,
        p.revisit_date,
        p.created_at
    FROM prescriptions p
    JOIN users u ON p.patient_id = u.id
    $filterQuery
    ORDER BY p.id DESC";

                                        $result = mysqli_query($con, $query);
                                        $cnt = 1;
                                        if (mysqli_num_rows($result) == 0) {
                                            echo "<tr><td colspan='6' class='text-center text-danger'>No prescriptions found for selected date range.</td></tr>";
                                        } else {
                                            while ($row = mysqli_fetch_assoc($result)) {
                                                $revisitFormatted = !empty($row['revisit_date']) ? date("d/m/Y", strtotime($row['revisit_date'])) : '';
                                                $createdFormatted = !empty($row['created_at']) ? date("d/m/Y H:i", strtotime($row['created_at'])) : '';
                                        ?>
                                                <tr>
                                                    <td><?= $cnt++; ?></td>
                                                    <td><?= htmlentities($row['pname']); ?></td>
                                                    <td><?= htmlentities(substr($row['notes'], 0, 50)); ?>...</td>
                                                    <td><?= $revisitFormatted; ?></td>
                                                    <td><?= $createdFormatted; ?></td>
                                                    <td>
                                                        <button class="btn btn-info btn-sm view-details"
                                                            data-toggle="modal"
                                                            data-target="#detailsModal"
                                                            data-id="<?= $row['pid']; ?>"
                                                            data-patient="<?= htmlentities($row['pname']); ?>"
                                                            data-notes="<?= htmlentities($row['notes']); ?>"
                                                            data-scan="<?= htmlentities($row['scan']); ?>"
                                                            data-lab="<?= htmlentities($row['lab']); ?>"
                                                            data-revisit="<?= $row['revisit_date']; ?>"
                                                            data-created="<?= $createdFormatted; ?>">
                                                            View
                                                        </button>
                                                        <a href="view-prescription.php?delid=<?= $row['pid']; ?>"
                                                            class="btn btn-danger btn-sm"
                                                            onclick="return confirm('Are you sure you want to delete this prescription?');">
                                                            Delete
                                                        </a>
                                                    </td>
                                                </tr>
                                        <?php }
                                        } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div><!-- container-fullw -->

                    <!-- Details Modal -->
                    <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header bg-primary text-white">
                                    <h5 class="modal-title">Prescription Details</h5>
                                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <h5>Prescription Info</h5>
                                    <table class="table table-bordered">
                                        <tr><th>Patient</th><td id="dPatient"></td></tr>
                                        <tr><th>Notes</th><td id="dNotes"></td></tr>
                                        <tr><th>Scan</th><td id="dScan"></td></tr>
                                        <tr><th>Lab</th><td id="dLab"></td></tr>
                                        <tr><th>Revisit</th><td id="dRevisit"></td></tr>
                                        <tr><th>Created On</th><td id="dCreated"></td></tr>
                                    </table>

                                    <h5 class="mt-4">Medicines</h5>
                                    <div id="medicineDetails">Loading...</div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php include('include/footer.php'); ?>
        <?php include('include/setting.php'); ?>
    </div>

    <!-- JS -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#prescriptionTable').DataTable();

            $(document).on("click", ".view-details", function() {
                $("#dPatient").text($(this).data("patient"));
                $("#dNotes").text($(this).data("notes"));
                $("#dScan").text($(this).data("scan"));
                $("#dLab").text($(this).data("lab"));

                // Format revisit
                let revisitDate = $(this).data("revisit");
                if (revisitDate) {
                    let d = new Date(revisitDate);
                    $("#dRevisit").text(("0" + d.getDate()).slice(-2) + "/" +
                                        ("0" + (d.getMonth() + 1)).slice(-2) + "/" +
                                        d.getFullYear());
                } else {
                    $("#dRevisit").text("");
                }

                // Created on
                $("#dCreated").text($(this).data("created"));

                var prescriptionId = $(this).data("id");
                $("#medicineDetails").html("Loading...");
                $.get("fetch-medicines.php", { pid: prescriptionId }, function(data) {
                    $("#medicineDetails").html(data);
                });
            });
        });
    </script>
    <script>
$(document).ready(function () {
    $(".main-navigation-menu li > a").click(function (e) {
        var parentLi = $(this).parent("li");

        // If this menu has a submenu
        if (parentLi.find(".sub-menu").length > 0) {
            e.preventDefault(); // Prevent going to link

            // Toggle submenu
            parentLi.toggleClass("open");
            parentLi.find(".sub-menu").slideToggle(200);

            // Close other open menus (optional)
            parentLi.siblings().removeClass("open").find(".sub-menu").slideUp(200);
        }
    });
});
</script>

</body>
</html>
