<?php 
session_start();
include("../../includes/header.php");
include("../../config/config.php");

// Ensure only admin can access
if ($_SESSION['role'] != 'admin') die("Access denied");

$admin_id = $_SESSION['user_id'];

// Fetch admin name from users table
$sql = "SELECT name FROM users WHERE user_id = ?";
$stmt = $con->prepare($sql);
$stmt->bind_param("i", $admin_id);
$stmt->execute();
$stmt->bind_result($admin_name);
$stmt->fetch();
$stmt->close();
?>

<div class="container mt-5">
  <h2 class="mb-4">Admin Dashboard</h2>
  <p>Welcome <strong><?= htmlspecialchars($admin_name) ?></strong>! Manage and review Grievances submitted by employees.</p>

  <div class="card p-3 shadow">
    <h5>Pending Grievance</h5>
    <p><a href="manage_feedback.php" class="btn btn-sm btn-primary">View Grievance</a></p>
  </div>
</div>

<?php include("../../includes/footer.php"); ?>
