<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Feedback System - Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: url('login.jpg');
      background-size: cover;
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .login-box {
      background: #ffffffbd;
      padding: 30px;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(0,0,0,0.2);
      width: 100%;
      max-width: 400px;
    }
    .login-box h2 {
      margin-bottom: 20px;
      text-align: center;
      color: #333;
    }
    .form-control {
      border-radius: 8px;
    }
    .btn-primary {
      width: 100%;
      border-radius: 8px;
      padding: 10px;
    }
    footer {
      margin-top: 15px;
      text-align: center;
      font-size: 0.9em;
      color: #666;
    }
  </style>
</head>
<body>

<div class="login-box">
  <h2>🔐 Login</h2>
  <form method="POST" action="../actions/login_action.php">
    <div class="mb-3">
      <label>Email</label>
      <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
    </div>
    <div class="mb-3">
      <label>Password</label>
      <input type="password" name="password" class="form-control" placeholder="Enter password" required>
    </div>
    <button type="submit" name="login" class="btn btn-primary">Login</button>
  </form>
  <footer>
    &copy; <?php echo date("Y"); ?> Grievance
  </footer>
</div>

</body>
</html>
