<?php
include("../../includes/auth_check.php");
include("../../includes/header.php"); // use dashboard layout
include("../../config/config.php");

if ($_SESSION['role'] != 'superadmin') die("Access denied");

if (isset($_POST['add'])) {
    $name = $_POST['dept_name'];
    $stmt = $con->prepare("INSERT INTO departments (dept_name) VALUES (?)");
    $stmt->bind_param("s", $name);
    $stmt->execute();
}

$res = $con->query("SELECT * FROM departments");
?>

<div class="container mt-4">
  <h2 class="mb-4">🏢 Departments</h2>

  <!-- Add Department Form -->
  <div class="card shadow-sm mb-4">
    <div class="card-body">
      <form method="POST" class="row g-3">
        <div class="col-md-8">
          <input type="text" name="dept_name" class="form-control" placeholder="Enter Department Name" required>
        </div>
        <div class="col-md-4">
          <button name="add" class="btn btn-primary w-100">Add Department</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Departments Table -->
  <div class="card shadow-sm">
    <div class="card-body">
      <h5 class="card-title mb-3">Department List</h5>
      <table class="table table-bordered table-striped align-middle">
        <thead class="table-dark">
          <tr>
            <th style="width: 80px;">ID</th>
            <th>Department Name</th>
          </tr>
        </thead>
        <tbody>
          <?php while($d = $res->fetch_assoc()): ?>
            <tr>
              <td><?= $d['dept_id'] ?></td>
              <td><?= htmlspecialchars($d['dept_name']) ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include("../../includes/footer.php"); ?>
