<?php
include("../../includes/auth_check.php");
include("../../includes/header.php");
include("../../config/config.php");

if ($_SESSION['role'] != 'superadmin') die("Access denied");

$sql = "SELECT f.feedback_id, f.status,
               u.name AS employee_name, 
               ua.name AS admin_name, 
               ft.type_name, 
               f.feedback_text, 
               f.created_at
        FROM feedbacks f
        JOIN users u ON f.user_id = u.user_id
        LEFT JOIN users ua ON f.admin_id = ua.user_id
        JOIN feedback_master ft ON f.feedback_type_id = ft.feedback_type_id
        ORDER BY f.created_at DESC";

$result = $con->query($sql);
?>

<div class="container mt-5">
    <h2 class="mb-4">Grievance Reports</h2>

    <div class="card shadow-sm">
        <div class="card-body">
            <table id="feedbackTable" class="table table-bordered table-striped align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Employees</th>
                        <th>Users</th>
                        <th>Grievance Type</th>
                        <th>Grievance</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $sn = 1;
                    while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= $sn++ ?></td>
                            <td><?= htmlspecialchars($row['employee_name']) ?></td>
                            <td><?= $row['admin_name'] ? htmlspecialchars($row['admin_name']) : "<span class='text-danger'>Not Assigned</span>" ?></td>
                            <td><?= htmlspecialchars($row['type_name']) ?></td>
                            <td><?= nl2br(htmlspecialchars($row['feedback_text'])) ?></td>
                            <td>
                                <?php
                                if ($row['status'] == 'pending') {
                                    echo "<span class='badge bg-warning'>Pending</span>";
                                } elseif ($row['status'] == 'accepted') {
                                    echo "<span class='badge bg-success'>Approved</span>";
                                } elseif ($row['status'] == 'rejected') {
                                    echo "<span class='badge bg-danger'>Rejected</span>";
                                } else {
                                    echo "<span class='badge bg-secondary'>Unknown</span>";
                                }
                                ?>
                            </td>
                            <td><?= date("d-m-Y H:i", strtotime($row['created_at'])) ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>

        </div>
    </div>
</div>

<?php include("../../includes/footer.php"); ?>
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<!-- JS dependencies for buttons -->
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>

<!-- JS libraries for Excel/PDF export -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script>
$(document).ready(function() {
    $('#feedbackTable').DataTable({
        "pageLength": 10,
        "lengthMenu": [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]], // explicitly set both values and labels
        "order": [[6, "desc"]],
        "columnDefs": [
            { "orderable": false, "targets": [0, 4] }
        ],
        dom: 'Bflrtip', // B = buttons, f = filter, l = length, r = processing, t = table, i = info, p = pagination
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
    });
});
</script>

<script>

</script>
