<?php
include("../../config/config.php");

$id = intval($_POST['feedback_type_id']);
$name = trim($_POST['type_name']);
$desc = trim($_POST['description']);
$dept_id = !empty($_POST['department_id']) ? intval($_POST['department_id']) : null;

if ($dept_id) {
    $stmt = $con->prepare("UPDATE feedback_master SET type_name=?, description=?, department_id=? WHERE feedback_type_id=?");
    $stmt->bind_param("ssii", $name, $desc, $dept_id, $id);
} else {
    $stmt = $con->prepare("UPDATE feedback_master SET type_name=?, description=?, department_id=NULL WHERE feedback_type_id=?");
    $stmt->bind_param("ssi", $name, $desc, $id);
}

if ($stmt->execute()) {
    echo "✅ Feedback Type updated successfully.";
} else {
    echo "❌ Update failed: " . $con->error;
}
?>
