<?php
include("../../includes/auth_check.php");
include("../../includes/header.php");
include("../../config/config.php");

if ($_SESSION['role'] != 'employee') die("Access denied");
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Submit Grievance</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="../../actions/feedback_submit.php" class="row g-3" enctype="multipart/form-data">

                        <!-- Feedback Type -->
                        <div class="col-md-12">
                            <label class="form-label">Grievance Type</label>
                            <select name="feedback_type" class="form-select" required>
                                <option value="">-- Select Grievance Type --</option>
                                <?php
                                $res = $con->query("SELECT * FROM feedback_master");
                                while ($row = $res->fetch_assoc()) {
                                    echo "<option value='".$row['feedback_type_id']."'>".$row['type_name']."</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <!-- Feedback Text -->
                        <div class="col-md-12">
                            <label class="form-label">Your Grievance</label>
                            <textarea name="feedback" class="form-control" rows="5" placeholder="Write your Grievance here..." required></textarea>
                        </div>

                        <!-- File Upload -->
                        <div class="col-md-12">
                            <label class="form-label">Attach File (optional)</label>
                            <input type="file" name="feedback_file" class="form-control" accept=".jpg,.jpeg,.png,.pdf,.doc,.docx">
                            <small class="text-muted">Allowed types: JPG, PNG, PDF, DOC, DOCX</small>
                        </div>

                        <!-- Submit Button -->
                        <div class="col-12 text-end">
                            <button type="submit" name="submit_feedback" class="btn btn-success">
                                Submit Grievance
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include("../../includes/footer.php"); ?>
