<?php
include("../../includes/auth_check.php");
include("../../includes/header.php");
include("../../config/config.php");

if ($_SESSION['role'] != 'employee') die("Access denied");

$user_id = $_SESSION['user_id'];

// Fetch employee's feedback (including file_path)
$sql = "SELECT f.feedback_id, ft.type_name, f.feedback_text, f.file_path, f.status, f.remarks, f.created_at
        FROM feedbacks f
        JOIN feedback_master ft ON f.feedback_type_id = ft.feedback_type_id
        WHERE f.user_id = ?
        ORDER BY f.created_at DESC";

$stmt = $con->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<div class="container mt-5">
    <h2 class="mb-4">My Grievance</h2>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-bordered table-striped align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Type</th>
                        <th>Grievance</th>
                        <th>File</th>
                        <th>Status</th>
                        <th>Reason (if rejected)</th>
                        <th>Submitted At</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php
                        $sn = 1;
                        while ($row = $result->fetch_assoc()):
                        ?>
                            <tr>
                                <td><?= $sn++ ?></td>
                                <td><?= htmlspecialchars($row['type_name']) ?></td>
                                <td><?= nl2br(htmlspecialchars($row['feedback_text'])) ?></td>

                                <!-- File View / Download -->
                                <td>
                                    <?php if (!empty($row['file_path'])): ?>
                                        <?php
                                        $ext = strtolower(pathinfo($row['file_path'], PATHINFO_EXTENSION));
                                        $fileUrl = "../../" . htmlspecialchars($row['file_path']);
                                        ?>
                                        <?php if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif'])): ?>
                                            <a href="<?= $fileUrl ?>" target="_blank">
                                                <img src="<?= $fileUrl ?>" alt="Attachment" width="60" height="60" class="rounded border">
                                            </a>
                                        <?php else: ?>
                                            <a href="<?= $fileUrl ?>" target="_blank" class="btn btn-sm btn-primary">
                                                View File
                                            </a>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="text-muted">No file</span>
                                    <?php endif; ?>
                                </td>

                                <!-- Status -->
                                <td>
                                    <?php if ($row['status'] == 'pending'): ?>
                                        <span class="badge bg-warning text-dark">Pending</span>
                                    <?php elseif ($row['status'] == 'accepted'): ?>
                                        <span class="badge bg-success">Accepted</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Rejected</span>
                                    <?php endif; ?>
                                </td>

                                <td><?= $row['remarks'] ?: '-' ?></td>
                                <td><?= date("d-m-Y H:i", strtotime($row['created_at'])) ?></td>
                                <td>
                                    <?php if ($row['status'] == 'rejected'): ?>
                                        <button class="btn btn-sm btn-warning"
                                            data-bs-toggle="modal"
                                            data-bs-target="#resubmitModal"
                                            data-id="<?= $row['feedback_id'] ?>"
                                            data-type="<?= htmlspecialchars($row['type_name']) ?>"
                                            data-text="<?= htmlspecialchars($row['feedback_text']) ?>">
                                            Re-Submit
                                        </button>
                                    <?php else: ?>
                                        <span class="text-muted">—</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8" class="text-center">No Grievance submitted yet.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<!-- Re-Submit Modal -->
<div class="modal fade" id="resubmitModal" tabindex="-1" aria-labelledby="resubmitModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="resubmitForm" method="POST" action="resubmit_feedback.php" enctype="multipart/form-data" class="modal-content">
      <div class="modal-header bg-warning">
        <h5 class="modal-title" id="resubmitModalLabel">Re-Submit Grievance</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <input type="hidden" name="feedback_id" id="feedback_id">

        <div class="mb-3">
          <label class="form-label">Type</label>
          <input type="text" id="feedback_type" class="form-control" readonly>
        </div>

        <div class="mb-3">
          <label class="form-label">Description</label>
          <textarea name="feedback_text" id="feedback_text" class="form-control" rows="3" required></textarea>
        </div>

        <div class="mb-3">
          <label class="form-label">Attach File (optional)</label>
          <input type="file" name="file_path" class="form-control">
        </div>
      </div>

      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Submit</button>
      </div>
    </form>
  </div>
</div>

<?php include("../../includes/footer.php"); ?>
<script>
const resubmitModal = document.getElementById('resubmitModal');
resubmitModal.addEventListener('show.bs.modal', event => {
    const button = event.relatedTarget;
    const id = button.getAttribute('data-id');
    const type = button.getAttribute('data-type');
    const text = button.getAttribute('data-text');

    document.getElementById('feedback_id').value = id;
    document.getElementById('feedback_type').value = type;
    document.getElementById('feedback_text').value = text;
});
</script>
